has parameters such as learning rate, number of hidden nodes and the activation function. These parameters can be varied to induce structural diversity [5]. The general equation of the output function of a MLP neural network is shown below (1). 

$$y_{k}=f_{outer}(\sum_{j=1}^{M}w_{kj}^{(2)}f_{inner}(\sum_{i=1}^{N}w_{ij}^{(1)}x_{j}+w_{j0}^{(1)})+w_{k0}^{(2)})\tag{1}$$

where: k

![0_image_0.png](0_image_0.png)

y **is the output from the neural network, is** 
the output activation function that can be linear, softmax or logistic, is the hidden layer tangential activation function. M is the number of the hidden units, N is the number of input units, )2( wkj and )1( wij **are the weights in** 
the first and second layer moving from input i to hidden unit j, )1( w0 j and )2( w0k are the biases for the unit j. 

The inputs into the neural network are the demographic data attributes from the HIV antenatal survey and the output is the HIV status of the individual where 0 represents negative and 1 represents positive. The weights of the NN are updated using a back propagation algorithm during the training stage [11].The threshold of 0.5 is used in order to achieve a zero or one solution from the neural network. This means that any value less than 0.5 is converted to 0 and any value more than 0.5 is converted to 1. 

## 2.2. **Genetic Algorithm**

The genetic algorithms (GA) are computational models that are based on the evolution of biological population [2]. Potential solutions are encoded as the chromosomes of some individual. These individuals are initially generated randomly. The individuals are evaluated through the defined fitness function. Each preceding generation is populated by the fitness solution (members) 
of the previous generation and their offspring. The offsprings are created through crossover and mutation. The crossover process combines genetic information of two previous fittest solutions to create new offsprings. Mutation alters the genes of the individual to introduce more diversity into the population. In this way, the initial generated solution can be improved over time [2, 12]. 

## 3. **Data Analysis** 3.1. **Data Collection**

The dataset used for the study is from antenatal clinics in South Africa and it was collected by the department of health in 2001. The features in the data include the age, gravidity, parity, education, etc. The demographic data used in the study is shown in table 1 below. The province was provided as a string so it was converted to an integer from 1 to 9. 

 Variable Type Range 

1 Age integer 13-50 

2 Education integer 0-13 

3 Parity integer 0-9 4 Gravidity integer 1-12 5 Province integer 1-9 6 Age of father integer 14-60 7 HIV status binary 0-1 

 

The age is that of the mother visiting the clinic. Education represents the level of education the mother has and ranges from 1-13, where 1-12 corresponds to grade 1 to 12 and 13 represents tertiary education. Parity is the number of times the mother has given birth whilst gravidity is the number of times the mother has been pregnant. Both these quantities are important, as they show the reproductive activity as well as the reproductive health state of the women. The age of the father responsible for the current pregnancy is also given and the province entry corresponds to the geographic area where the mother comes from. The last feature is the HIV status of the mother where 0 represents a negative status whilst 1 represents a positive status. 

## 3.2. **Data Pre-Processing**

The data preprocessing is necessary in order to eliminate impossible situations such as parity being greater than gravidity because it is not possible for the mother to give birth without falling pregnant. The pre-processing of the data resulted in a reduction of the dataset. To use the dataset for training, it needs to be normalized because some of the data variables with larger variances will influence the result more than others. This ensures that all variables can contribute to the final network weights of the prediction model [13]. Therefore, all the data is to be normalized between 0 and 1 using (2). 