 The parser will check if ω can be reduced to S (the start symbol) by using the production rules. The quickest process to verify that is to use the production rules in the sequence shown below: 

$$\mathbf{\Phi}^{(0)}=\mathrm{abbcde}$$
$$\begin{array}{l l l}{{\rightarrow\mathrm{abbcBe}}}&{{(\mathrm{Rule~6}),\ \rightarrow\mathrm{aAbcBe}}}&{{(\mathrm{Rule~4}),}}\\ {{\rightarrow\mathrm{aAcBe}}}&{{(\mathrm{Rule~2}),\ \rightarrow\mathrm{S}}}&{{(\mathrm{Rule~1})}}\end{array}$$

 So, the parser program changes sub-strings of ω which matches the RHS of a production rule by the LHS of that production rule to get a new string. In this way it continues until a new string is obtained that matches/ is the start symbol S. If ultimately S is obtained as a new string, ω∈ L(G) , else it is not. Now, suppose, we are given to check whether the string ω = abbcde belongs to L(G) or not under the given production rules (1) - (6), i.e. we have to check whether ωcan be reduced to S or not using the given production rules. While implementing ACO algorithm to solve this problem, we first map the entire problem into an environment represented by a connected graph. This is, as already mentioned in section 3, the first step of solving any optimization problem by a discrete optimization algorithm like ACO. Corresponding to each production rule, which we can access to reduce ω to S, we create a node. Every node stores a production rule after splitting it into two halves. One is the LHS of the rule and the other is its RHS. Suppose, rule (1): 
S aAcBe → is needed to be stored in a node. Then, first we split the rule into two halves and store the LHS part S and the RHS part aAcBe separately. Therefore, each node contains exactly two stacks for storing the two halves of the production rule that it represents. A single node is connected to every other node, which implies that there is a provision of traversing from one node to any other node. Artificial ants are endowed with some attributes to move through this connected graph. Each ant is provided with the starting string ω . This string is stored in a stack in ant's memory. In the inception, ants are placed randomly on nodes and each ant tries to use the stacks already stored in the node in which it is placed. The procedure can be illustrated using the problem string "abbcde" and the rule B d → (rule 6). An ant placed in the node representing the rule B d → starts with the expression "abbcde" and tries to find whether any substring of "abbcde" matches with the string corresponding to the RHS expression "d". If there is a match, the ant replaces the sub-string of ω = abbcde with the other string present in the node (LHS of the production rule). Here an ant finds that the string "d" matches with a sub-string stored in its memory. 

Therefore it modifies the string stored in its memory to "abbcBe" . 

 Ant's transition from one node to another is guided by a probability based selection approach given in the following equation: 

∑ ∈ ⎧ ⎫ ⎪ ⎪ (τ )/ (τ ) if q<q ij ik k k: k Ni 0 k k i i 0 k i 0 P (j) 1, if τ =max{(τ ):k N } with q >q (2) = ∈ ⎨ ⎬ ⎪ ⎪ ≠ ∈ ⎩ ⎭ ij ik ik ij 0,if τ max{(τ ):k N } with q >q
The difference between (1) and (2) is that here we do not consider any heuristic information. In the beginning, the search space is covered with uniform pheromone concentration. So, ants do not have any idea as how to move through the graph. It, therefore, selects the next node randomly and tries to match the modified string that it contains now in its memory with the strings stored in that node. If ant finds the strings useful so that either of them matches with any substring of the expression stored in ant's memory, ant modifies the expression with the other string stored in that node as before and moves to the next node. If an ant does not find the information in the current node useful, it stops moving in the graph (i.e. it becomes inactive). Each time an ant updates its position (i.e. moves from one node to the other), it checks the expression that it is modifying and the expression that it has to arrive at (which is S). If these strings match, it indicates that the ant has discovered steps through which S can be arrived at starting from ωand the ant stops moving. There is, however, no restriction in visiting a particular node more than once because in process of deriving one expression from the other, we might require to use a rule more than once. 

![0_image_0.png](0_image_0.png)

