3. *Fuzzy association rules for a limited and validated set of "hot conclusions"* 
concerning the dynamics of a knowledge domain 

## 3.1. Definition Of Association Rules

Data mining techniques can be used to analyse large amounts of data (see Hand et al. [17]). Association Rules Extraction belongs to these techniques. It is a method for extracting knowledge relative to links between variables from data which can be represented by a boolean array of type O*V, where O is a set of objects, V a set of variables, and the boolean values indicate the presence or absence of a relation (such as belonging) between each variable and each object. The most widely cited association rule was extracted from US market basket data composed of transactions (lists of items bought in a single purchase by a customer): "x buys diapers Æ x buys beers" (Han et al. [18]). In this market database, V is the item set, O the transaction set, and the values TRUE/FALSE indicate whether items are present or not in this transaction. Clearly, not all the customers who buy diapers also buy beers. But the proportion of customers that verify this surprising rule is sufficiently high to be interesting to supermarket managers. Presently, association rules extraction is not used to mine only marketing databases. It is an efficient data mining technique for extracting knowledge from most databases (Cadot et al [19]), for example corpuses of scientific texts as in the proposed application. AR are commonly mined in two steps (Agrawal et al. [20]). First, new variables, called itemsets, are derived from the variables of the set V. For doing so, each object is affected a value of this new variable, say AB, by means of a logical AND on the concerned variables, A and B. The support of the itemset is the number of objects set to TRUE, in other words the number of "common" objects for the variables in the itemset. By fixing a threshold to the support value one can limit the number of extracted itemsets; those are called "frequent itemsets". The quest for powerful algorithms to do so is still a concern today. Most usual algorithms (Bastide [21]) are iterative ones (such as Agrawal « Apriori ») in which the knowledge of frequent itemsets of length k enables one to extract the ones of length k-1. The second step consists in splitting each itemset (k>1) into two item subsets A and B in order to test the association rule AÆB. For limiting the number of generated rules, a threshold is applied to a quality criterion; the confidence (conf(AÆB) = supp(AB) / supp(A)) is generally chosen. More than fifty quality criteria have been proposed yet (Guillet et al. [22]), each one embedding some specific semantic facet of the association rule. At last, the whole set of extracted AR is presented to the domain expert, jointly with some selected quality criteria. This extraction method is currently enhanced along several directions: for time-efficiency, for taking into account more data-types, or more rule types. Specifically for non-boolean variables, e.g. with values scaling from 0 to 1, it is possible to define fuzzy itemsets by commuting the AND operator into a fusion operator adapted to real positive values (Cadot et al. [23]). This is the case for our clustering results on geotechnics data (Cuxac et al. [4]). We have then built fuzzy interclusters itemsets, which enabled us to induce fuzzy AR between our topics. 

 But many of the (too many!) rules derived from more than 2-items sets proved meaningless. This was one of our motivations for designing our MIDOVA index (Multidimensional Interaction Differential of Variables Association), so as to present to the expert the only rules built on itemsets showing an information content greater than their subsets (Cadot et al. [24]), thus eliminating useless redundancy. The numerical and dimensional properties of this index, formally similar to those of the support, allow for using an Apriori-like algorithm, for quickly extracting itemsets (whose MIDOVA absolute value reflects a strong association when the value is positive, a strong repulsion in the negative case). Most of the rules derived from itemsets with highly positive MIDOVA indices proved meaningful. 