
## 3.2. Use Of Association Rules For Comparing Classes

Let C1 and C2 be two distinct classifications of two [documents × keywords] datasets sharing the same common keywords, A be a C1 class, B be a C2 class. Let us consider the matrix whose lines are the keywords (the O set), columns are the union V of the class labels of C1 and C2, and values are the typicalities of the keywords in each class, as defined above in 2.2. 

 The association between A and B may be considered as the itemset AB, i.e. a new column condensing the content of the two classes. The quality of the AÆB rule depends on the « degree of inclusion » of A in B, as defined above by our notions of fuzzy itemsets and fuzzy rules. 

 In a first approximation, we will consider interesting the associations featured with a strictly positive MIDOVA coefficient. There are 236 of those in our dataset, issued from 182 C1 classes (upon 297 with one word at least) and 200 C2 classes(upon 497). 

|            | B   | (C2)   | Total   |     |     |
|------------|-----|--------|---------|-----|-----|
| # premises | 1   | 2      | 3       |     |     |
| A          | 1   | 114    | 12      | 1   | 127 |
| (C1)       | 2   | 20     | 6       | 26  |     |
| 3          | 4   | 1      | 5       |     |     |
| 4          | 1   | 1      |         |     |     |
| 5          | 1   | 1      |         |     |     |
| Total      | 139 | 19     | 2       | 160 |     |
| Table 3    |     |        |         |     |     |

 In Table 3 we cross-count rules with 1,2,…5 premises issued from C1 classes along with rules with 1,…3 premises issued from C2 classes. This table shows four prominent types of associations: 
- the "114" value means that there exist 114 AB "unique" itemsets, unique in that no itemsets can be found with the same class A from C1 and another class from C2 - which can be interpreted as a reciprocal coverage of A and B; of course we mean here a fuzzy coverage. 

- "12" means that 12 C1 classes generate itemsets AB and AB', where B and B' are two C2 classes, thus generate 24 associations. We can interpret that as a split of A into two classes B and B'. 

- "20" can be interpreted symmetrically as a fuzzy melting of two C1 classes A and A' into one C2 class B. 

- "6" means that there are 6 C1 pairs (A, A') associated with 6 C2 pairs (B, B') into 4 itemsets AB, A'B, AB' and A'B', signalling cross-melting/splitting processes. 
 To summarize, 114 C1 (2003) classes stayed practically unchanged in 2004, 68 C1 classes combined by melting/splitting into 86 modified C2 (2003-2004) classes. The 115 C1 classes out of the table have no association with C2 classes, thus disappeared. The 297 C2 classes out of the table are newcomers. 

 This global comparison of the classifications C1 and C2 can be complemented with local fuzzy AR. 

We show here as an example two rules describing the split of a 2003 class ("Groundwater flow ") into two 2003-2004 classes ("Response of exploited underground water-table", "Groundwater flow "): 
Rule(1) A03t1526Æa34t2564 ; support : 6.65, MIDOVA : 3.29, confidence : 0.66 Rule(2) A03t1526Æa34t0253 ; support : 5.74, MIDOVA : 1.47, confidence : 0.57 The high support and MIDOVA values show the strong similarity between the two pairs. The higher confidence in rule (1) is a sign of dissymmetry, the class A03t1526 being a bit more influenced in the direction of a34t2564. 

In the same way, other noticeable examples may be cited: 