# Modeling Social Annotation: A Bayesian Approach

Anon Plangprasopchok and Kristina Lerman USC Information Sciences Institute Collaborative tagging systems, such as Delicious, CiteULike**, and others, allow users to annotate**
resources, e.g., Web pages or scientific papers, with descriptive labels called tags. The social annotations contributed by thousands of users, can potentially **be used to infer categorical knowledge,**
classify documents or recommend new relevant information. **Traditional text inference methods**
do not make best use of social annotation, since they do not take into account variations in individual users' perspectives and vocabulary. In a previous work, **we introduced a simple probabilistic**
model that takes interests of individual annotators into account in order to find hidden topics of annotated resources. Unfortunately, that approach had one **major shortcoming: the number of**
topics and interests must be specified a priori**. To address this drawback, we extend the model**
to a fully Bayesian framework, which offers a way to automatically estimate these numbers. In particular, the model allows the number of interests and topics to change as suggested by the structure of the data. We evaluate the proposed model in detail on the synthetic and real-world data by comparing its performance to Latent Dirichlet Allocation on the topic extraction task.

For the latter evaluation, we apply the model to infer topics of Web resources from social annotations obtained from Delicious in order to discover new resources similar to a specified one. Our empirical results demonstrate that the proposed model is a promising method for exploiting social knowledge contained in user-generated annotations.

Categories and Subject Descriptors: H.2.8 [**DATABASE MANAGEMENT**]: Database Applications—*Data mining*; I.5.1 [**PATTERN RECOGNITION**]: Models—*Statistical* General Terms: Algorithms, Experimentation Additional Key Words and Phrases: Collaborative Tagging, Probabilistic Model, Resource Discovery, Social Annotation, Social Information Processing

## 1. Introduction

A new generation of Social Web sites, such as Delicious, Flickr, CiteULike, *YouTube*, and others, allow users to share content and annotate it with metadata in the form of comments, notes, ratings, and descriptive labels known as tags. Social annotation captures the collective knowledge of thousands of users and can potentially be used to enhance a number of applications including Web search, information personalization and recommendation, and even synthesize categorical knowledge [Schmitz 2006; Mika 2007]. In order to make best use of user-generated metadata, we need methods that effectively deal with the challenges of data sparseness and noise, as well as take into account variations in the vocabulary, interests, and the level of expertise among individual users.

Consider specifically *tagging*, which has become a popular method for annotating conarXiv:0811.1319v2 [cs.AI] 26 May 2010