Modeling Social Annotation: a Bayesian Approach · 11

![0_image_0.png](0_image_0.png) 

of resources over topics. We ran the learning algorithm five times for each data set.

Deviations between learned topics and actual ones of simulated data sets are shown in Figure 3 and Figure 4. In the case when degree of tag ambiguity is high, ITM is superior to LDA for the entire range of user interest variation, as shown in Figure 3(a). This is because ITM exploits user information to help disambiguate tag senses; thus, it can learn better topics, which are closer to the actual ones, than LDA. In the other regime, when tag ambiguity is low, user information does not help and can even degrade ITM performance, especially when the degree of interest variation is low, as in Figure 3(b). This is because low amount of user interest variation demotes statistical strength of the learned topics. Suppose that, for example, we have two similar resources: the first one is bookmarked by one group, the second bookmarked by another. If these two groups have very different interest profiles, ITM will tend to split the "actual" topic that describes those resources into two different topics - one for each group. Hence, each of these resources will be assigned to a different learned topic, resulting in a higher ∆ for ITM.

In the case when user interest variation is high (Figure 3(c)), ITM is superior to LDA for the same reason that it uses user information to disambiguate tag senses. Of course, there is no advantage to using ITM when the degree of tag ambiguity is very low, and it yields similar performance to LDA. In the last regime, when interest variation is low (Figure 3(d)), ITM is superior to LDA for high degree of tag ambiguity, even though its topics may lose some statistical strength. ITM's performance starts to degrade when tag ambiguity degree is low, for the same reason as in Figure 3(b). These results are summarized in 3D plots in Figure 4.

We also ran LDA with 30 topics, in order to compare LDA to ITM, when both models have the same complexity. As shown in the Figure 3, with the same model complexity, ITM is preferable to LDA in all settings. In some cases, LDA with higher complexity (30 topics) is inferior to the LDA with lower complexity (10 topics). We suspect that this degradation is caused by over-specification of the model with too many topics.

For the computational complexity, both LDA and ITM are required to sample the hidden variables for all data points using Gibbs sampling. For LDA, only the topic variable z is needed to be sampled; for ITM, the interest variable x is also required. The computational cost in each sampling is proportional to a number of topics, NZ, for z, and that of interest, NX, for x. Let define κ as a constant. We also define a number of all datapoints (tuples)
ACM Journal Name, Vol. x, No. y, zz 2010.