Note that if we compare Eq. (10) to Eq. (8), the problem we found so far has gone since p(zi = k|z−i, z, t) will never have zero probability even if Nri,z−i = 0.

At the end of each iteration, we use the same method [Teh et al. 2006] to sample α and β and update hyperparameters γz, γx, µz, µx using the method described in [Escobar and West 1995]. We refer to this infinite version of ITM as "Interest Topic Model with Hierarchical Dirichlet Process" (HDPITM) for the rest of the paper.

For the computational complexity, although NZ and NX are both set to approach ∞,
the computational cost of each iteration, however, does not approach ∞. Considering Eq. (10) and Eq. (11), sampling of zi only involves currently instantiated topics plus one
"collapsed topic", which represents all currently unused topics. Similarly, the sampling of xi only involves currently instantiated interests plus one. For a particular iteration, a computational cost for HDP can therefore be approximated as NK × (κ × N¯Z + 1). And that for HDPITM can be approximated as NK × (κ × (N¯Z + N¯X + 2)), where N¯Z and N¯X are respectively the average number of topics and interests in that iteration.

## 5.1 Performance On The Synthetic Data

We ran both HDP and HDPITM to extract topic distributions, φ, on the simulated data set. In each run the number of instantiated topics was initialized to ten, which equals to the actual number of topics for both HDP and HDPITM. The number of interests was initialized to three. Similar to the setting in Section 4.1, topic and interest assignments were randomly initialized and then trained using 1000 iterations. Subsequently, φ was computed from the last 100 iterations. The results are shown in Figure 8 (a) and (b) for HDP and HDPITM respectively. From these results, the behaviors of both model for different settings are somewhat similar to those of LDA and ITM. In particular, HDPITM can exploit user information to help disambiguate tag senses, while HDP cannot. Hence, the performance of HDPITM is better than that of HDP when tag ambiguity level is high. And since topics may lose some statistical strength under low user interest condition, HDPITM is inferior to HDP, similar to Figure 3(b) for the finite case.

As one can compare the plots (a) and (b) in Figure 3 and Figure 8, the performance of infinite model is generally worse than that of the finite one, even though we allow the former the ability to adjust topic/interest dimensions. One possible factor is that the model still allows topic/interest dimensions (configuration) to change even though the trained model is in a "stable" state. That would prohibit the model from optimizing its parameters for a certain configuration of topic/interest dimensions. One evidence that supports this claim is that, although the log likelihood seems to converge, the number of topics (for both models) and interests (only for HDPITM) still slightly fluctuate around a certain value.

From this speculation, we ran both HDP and HDPITM with the different strategy. In particular, we split model training into two periods. In the first period, we allow the model to adjust its configuration, i.e. the dimensions of topics and interests. In the second period, we still train the model but do not allow the dimensions of topics and interests to change. The first one is similar to the training process in the plain HDP and HDPITM. The second one is similar to that of plain LDA and ITM that use the latest configuration from the first period. In this experiment, we set the first period to 500 iterations; another 500 iterations were set for the second phase. Subsequently, φ is computed from the last 100 iterations of the second. We refer to this training strategy for HDP as HDP+LDA, and that for HDPITM as HDPITM+ITM. The overall improvement of performance using this strategy are perceived in Figure 8 (c) and (d), comparing to (a) and (b). That is, both HDP+LDA and ACM Journal Name, Vol. x, No. y, zz 2010.