tent on the Social Web. When a user tags a resource, be it a Web page on the social bookmarking cite *Delicious*, a scientific paper on *CiteULike*, or an image on the social photosharing site *Flickr*, the user is free to select any keyword, or tag, from an uncontrolled personal vocabulary to describe the resource. We can use tags to categorize resources, similar to the way documents are categorized using their text, although the usual problems of sparseness (few unique keywords per document), synonymy (different keywords may have the same meaning), and ambiguity (same keyword has multiple meanings), will also be present in this domain. Dimensionality reduction techniques such as topic modeling [Hofmann 1999; Blei et al. 2003; Buntine et al. 2004], which project documents from word space to a dense topic space, can alleviate these problems to a certain degree. Specifically, such projections address the sparseness and synonymy challenges by combining "similar" words together in a topic. Similarly, the challenge of word ambiguity in a document is addressed by taking into account the senses of co-appearing words in that document. In other words, the sense of the word is determined jointly along with the other words in that document.

Straightforward application of the previously mentioned methods to social annotation would aggregate resource's tags over all users, thereby losing important information about individual variation in tag usage, which can actually help the categorization task. Specifically, in social annotation, similar tags may have different meanings according to annotators' perspectives on the resource they are annotating [Lerman et al. 2007]. For example, if one searches for Web resources about car prices using the tag "jaguar" on *Delicious*, one receives back a list of resources containing documents about luxury cars and dealers, as well as guitar manuals, wildlife videos, and documents about Apple Computer's operating system. The above mentioned methods would simply compute tag occurrences from annotations across all users, effectively treating all annotations as if they were coming from a single user. As a result, a resource annotated with the tag "jaguar" will be undesirably associated with any sense of the keyword simply based on the number of times that keyword
(tag) was used for each sense.

We claim that users express their individual interests and vocabulary through tags, and that we can use this information to learn a better topic model of tagged resources. For instance, we are likely to discover that users who are interested in luxury cars use the keyword "jaguar" to tag car-related Web pages; while, those who are interested in wildlife use
"jaguar" to tag wildlife-related Web pages. The additional information about user interests is essential, especially since social annotations are generally very sparse.1In a previous work, [Plangprasopchok and Lerman 2007], we proposed a probabilistic model that takes into account interest variation among users to infer a more accurate topic model of tagged resources. In this paper we describe a Bayesian version of the model (Section 3). We explore its performance in detail on the synthetic data (Section 4.1) and compare it to Latent Dirichlet Allocation (LDA) [Blei et al. 2003], a popular document modeling algorithm.

We show that in domains with high tag ambiguity, variations among users can actually help discriminate between tag senses, leading to a better topic model. Our model is, therefore, best suited to make sense of social metadata, since this domain is characterized both by a high degree of noise and ambiguity and a highly diverse user population with varied