
## 5.2 Performance On The Real-World Data

In the experiments, we initialize the numbers of topics and interests to 100 and 20 (the number of interests is only applicable to HDPITM), and train the models on the same realworld data sets we used in Section 4.2. The topic and interest assignments are randomly initialized, and then both models are trained with the minimum 400 and maximum 600 iterations. For the first 100 iterations, we allow both models to instantiate a new topic or interest as required, under the constraint that the number of topics and interests does not exceed 400 and 80 respectively. If the model violates this constraint, it will exit this phase early. For the remainder of iterations, we do not allow the model to add new topics or interests (but these numbers can shrink if some topics/interests collapsed during this phase). Then, if the change in log likelihood, averaged over the 10 preceding iterations, is less than 2%, the training process will enter to final learning phase. (See Figure 9 (f) for an example of log likelihood during training iterations.) In fact, we found that the process enters the final phase early in all data sets. In the final phase, consisting of 100 iterations, we use the topic and interest assignments in each iteration to compute the distributions of resources over topics.

The reason we limit the maximum numbers of topics, interests, and iterations over which these models are allowed to instantiate a new topic/interest, is that the numbers of users and tags in our data sets are large, and many new topics and interests could be instantiated. This would require many more iterations to converge, and the models would require more memory than is available on the desktop machine we used in the experiments.17 We would rather allow the model to "explore" the underlying structure of data within the constraints - in other words, find a configuration which is best suited to the data under a limited exploration period and then fit the data within that configuration. At the end of the parameter estimation, the numbers of allocated topics of HDP models for flytecomm, geocoder, wunderground, *whitepages* and *online-reservationz* was 171, 174, 197, 187 and 175 respectively. The numbers of allocated topics and interests in HDPITM are h307, 43i, h329, 44i, h231, 81i, h225, 78i and h207, 72i respectively, which is bigger than those inferred by HDP in all cases. These results suggests that user information allows the HDPITM discover more detailed structure.

HDPITM performs somewhat better than HDP in flytecomm, *online-reservationz*, and geocoder data sets. Its performance for *wunderground* and *whitepages*, however, is almost identical to HDP. As in Section 4.2, this is possibly due to high interest variation among users. We suspect that weather and directory services are of interest to all users, and are therefore bookmarked by a large variety of users.

## 6. Related Research

Modeling social annotation is an emerging new field, but it has intellectual roots in two other fields: document modeling and collaborative filtering. It is relevant to the former in that one can view a resource being annotated by users with a set of tags to be analogous to a document, which is composed of words from the document's authors. Usually, the numbers of users involved in creating a document is much less than those involved in annotating a resource. In regard to collaborative rating systems, annotations created by users in a social annotation system are analogous to object ratings in a recommendation system. However,