can only produce small improvement or even similar performance to that of the simpler models. For a practical reason, a heuristic for determining level of tag ambiguity and user variation would be very beneficial in order to determine if the complex model is preferable to the simpler one. Ratios between a number of tags and that of users or that of resources may provide some clues.

As we model the social annotation process by taking into account all essential entities; namely, users, resources and tags, we can apply the model to other applications. For example, one can straightforwardly apply the model to personalize search [Wu et al. 2006; Lerman et al. 2007]. It can also be used to suggest tags to a user annotating a new resource, in the same spirit as rating predictions in Collaborative Filtering.

## Appendix

We begin to derive Gibbs sampling equations for ITM in Section 3 from the joint probability of t, x and z of all tuples. Suppose that we have n tuples. Their joint probability is defined as

p ( ti, xi, zi;i = 1 : n)
=
Zp(ti, xi, zi|**ψ, φ, θ**;i = 1 : n).p(ψ, φ, θ)dh**ψ, φ, θ**i
= c ·
Z Y
i=1:n
(ψui,xi· φri,zi· θti,zi,xi) ·Y
u,x
ψ
β/NX −1
u,x
·Y
r,z
φ
α/NZ −1
r,z ·Y
t,x,z
θ
η/NT −1
t,x,z dh**ψ, φ, θ**i
= c ·
Z Y
u,x
ψ
Pi
δu(xi,x)+β/NX−1
u,x d(ψ) ·
Z Y
r,z
φ
Pi
δr(zi,z)+α/NZ −1
r,z d(φ)
·Z Y
t,z,x
θ
Pi
δz,x(ti,t)+η/NT −1
t,z,x d(θ)
= c ·Y
r
(
Qz Γ(Pi
δr(zi, z) + α/NZ)
Γ(Nr + α)) ·Y
u
(
Qx Γ(Pi
δu(xi, x) + α/NX)
Γ(Nu + β))
·Y
z,x
(
Qz,x Γ(Pi
δz,x(ti, t) + η/NT )
Γ(Nz,x + η)) (14)
where c = (Γ(α)
Γ(α/NZ )
z )
r· (Γ(β)
Γ(β/NX)
x )
u· (Γ(η)
Γ(η/NT )
t )
(z,x)and δr(zi, z) is a function which
returns 1 if zi = z and ri = r otherwise 0. Nr represents a number of all tuples associated with resource r. Similarly, Nx,z represents a number of all tuples associated with interest x and topic z.

By rearranging Eq. (14), we obtain

$p(t_{i},x_{i},z_{i};i=1:n)\,=\,\prod_{r}\,(\frac{\Gamma(\alpha)}{\Gamma(N_{r}+\alpha)})\cdot\prod_{r,z}\,(\frac{\Gamma(\sum_{i}\delta_{r}(z_{i},z)+\alpha/N_{Z})}{\Gamma(\alpha/N_{Z})})$  $$\cdot\prod_{u}\,(\frac{\Gamma(\beta)}{\Gamma(N_{u}+\beta)})\cdot\prod_{u,z}\,(\frac{\Gamma(\sum_{i}\delta_{u}(x_{i},x)+\beta/N_{X})}{\Gamma(\beta/N_{X})})$$  ACM Journal Name, Vol. x, No. y, zz 2010.  