interests.

As a second contribution of the paper, we incorporate a Hierarchical Dirichlet Process [Teh et al. 2006] to create an adaptive version of the proposed model (Section 5), which enables the learning method to automatically adjust the model parameters. This capability helps overcome one of the main difficulties of applying the original model to the data: namely, having to specify the right number of topics and interests.

Finally, the proposed models are validated on a real-world data set obtained from the social bookmarking site *Delicious* (Section 4.2 and Section 5.2). We first train the model on this data, then measure the quality of the learned topic model. Specifically, the learned topic model is used as a compressed description of each Web resource. We compute similarity between resources based on the compressed description and manually evaluate results to show that the topic model obtained by the method proposed in this paper identifies more similar resources than the baseline.

## 2. Modeling Social Annotation

In general, a social annotation system involves three entities: resources (e.g., Web pages on *Delicious*), users and metadata. Although there are different forms of metadata, such as descriptions, notes and ratings, we focus on tags only in this context. We define a variable R as resources, U as users, and T as tags. Their realizations are defined as r, u and t respectively. A post (or bookmark) k on a resource r by a user u, can be formalized as a tuple hr, u, {t1, t2**, . . . , t**j}ik, which can be further broken down into co-occurrence of j resource-user-tag triples: h**r, u, t**i. NR, NU and NT are the number of distinct resources, users and tags respectively.

In addition to the observable variables defined above, we introduce two 'hidden' or
'latent' variables, which we will attempt to infer from the observed data. The first variable, Z, represents resource topics, which we view as categories or concepts of resources. From our previous example, the tag "jaguar" can be associated with topics 'cars', 'animals',
'South America', 'computers', etc. The second variable, X, represents user interests, the degree to which users subscribe to these concepts. One user may be interested in collecting information about luxury cars before purchasing one, while another user may be interested in vintage cars. A user u has her interest profile, ψu, which is a weight distribution over all possible interests x. And ψ (without subscript) is just an NU × NX matrix. Similarly, a resource r has its topic profile, φr, which is again a weight distribution over all possible topics z, whereas φ (without subscript) is an NR×NZ matrix. Thus, a resource about South American jaguars will have a higher weight on 'animals' and 'South America' topics than on the 'cars' topic. Usage of tags for a certain interest-topic pair (**x, z**) is defined as a weight distribution over tags, θx,z - that is, some tags are more likely to occur for a given pair than others. The weight distribution of all tags, θ, can be viewed as an NT ×NZ ×NX
matrix.

We cast an annotation event as a stochastic process as follows: