Modeling Social Annotation: a Bayesian Approach · 5

![0_image_0.png](0_image_0.png) 
Fig. 2. Graphical representation of the social annotation process. R, U, T, X and Z denote variables "Resource",
"User", "Tag", "Interest" and "Topic" respectively. ψ, φ and θ are distributions of user over interests, resource over topics and interest-topic over tags respectively. Nt represents the number of tag occurrences for one bookmark (by a particular user, u, on a particular resource, r); D represents the number of all bookmarks in the social annotation system. The hyperparameters α, β, and η control dispersions of categorical topics, interests and tags respectively.

is also no explicit way to extend these models to automatically infer the dimensions of parameters, such as the number of components used to represent topics (NZ) and interests (NX).

We extend our previous Interest Topic Model (ITM) the same way pLSA was upgraded to Latent Dirichlet Allocation (LDA) model [Blei et al. 2003]. In other words, we implement the model under a Bayesian framework, which offers solutions [Blei et al. 2003; Griffiths and Steyvers 2004; Neal 2000] to the previously mentioned problems. By doing so, we introduce priors on top of parameters ψ, φ and θ to make the model fully generative, i.e., the mechanism for generating these parameters is explicitly implemented. To make the model analytically simple, we use symmetric Dirichlet priors. Following the generative process described in Section 2, the model can be described as a stochastic process, depicted a graphical form [Buntine 1994] in Figure 2:
. ψu ∼ Dirichlet(β/NX**, ..., β/N**X) (generating user u interest's profile)
. φr ∼ Dirichlet(α/NZ**, ..., α/N**Z) (generating resource r topic's profile) . θx,z ∼ Dirichlet(η/NT **, ..., η/N**T ). (generating tag's profile for interest x and topic z)
For each tag ti of a bookmark,
. xi ∼ **Discrete**(ψu)
. zi ∼ **Discrete**(φr)
. ti ∼ **Discrete**(θxi,zi).

One possible way to estimate parameters is to use Gibbs sampling [Gilks et al. 1996; Neal 2000]. Briefly, the idea behind the Gibbs sampling is to iteratively use the parameters ACM Journal Name, Vol. x, No. y, zz 2010.