explicit way to extend these approaches to automatically infer the size of hidden variables, as Gibbs sampling can. Note that inference of these numbers is described in Section 5.

## 4. Evaluation

In this section we evaluate the Interest Topic Model and compare its performance to LDA [Blei et al. 2003] on both synthetic and real-world data. The synthetic data set enables us to control the degree of tag ambiguity and individual user variation, and examine in detail how both learning algorithms respond to these key challenges of learning from social metadata. The real-world data set, obtained from the social bookmarking site *Delicious*, demonstrates the utility of the proposed model.

The baseline in both comparisons is LDA, a probabilistic generative model originally developed for modeling text documents [Blei et al. 2003], and more recently extended to other domains, such as finding topics of scientific papers [Griffiths and Steyvers 2004], topic-author associations [Rosen-Zvi et al. 2004], user roles in a social network [McCallum et al. 2007], and Collaborative Filtering [Marlin 2004]. In this model, the distribution of a document over a set of topics is first sampled from a Dirichlet prior. For generating each word in the document, a topic is first sampled from the distribution; then, a word is selected from the distribution of topics over words. One can apply LDA to model how tags are generated for resources on social tagging systems. One straightforward approach is to ignore information about users, treating all tags as if they came from the same user. Then, a resource can be viewed as a document, while tags across different users who bookmarked it are treated as words, and LDA is then used to learn parameters.

ITM extends LDA by taking into account individual variations among users. In particular, a tag for a certain bookmark is chosen not only from the resource's topics but also from user's interests. This allows each user group (with the same interest) to have its own policy, θ**x,z,t**, for choosing tags to represent a topic. Each policy is then used to update resource topics as in Eq. (1). Consequently, φr,z is updated based on interests of users who actually annotated resource r, rather than updating it from a single policy that ignores user information. We thus expect ITM to perform better than LDA when annotations are made by diverse user groups, and especially when tags are ambiguous.

## 4.1 Synthetic Data

To verify the intuition about ITM, we evaluated the performance of the learning algorithms on synthetic data. Our data set consists of 40 resources, 10 topics, 100 users, 10 interests, and 100 tags. We first separate resources into five groups, with resources in each group assigned topic weights from the same (Dirichlet) probability distribution, which forces each resource to favor 2–4 out of ten topics. Rather than simulate the tagging behavior of user groups by generating individual tagging policy plates as in Figure 1(a), we simplify the generative process to simulate the impact of diversity in user interests on tagging. To this end, we represent user interests as distributions over topics.

We create data sets under different tag ambiguity and user interest variation levels. To make these settings *tunable*, we generate distributions of topics over tags, and distributions of resources over topics using symmetric Dirichlet distributions with different parameter values. Intuitively, when sampling from the symmetric Dirichlet distribution2 with a low