# Airport Gate Assignment: New Model And Implementation

## Chendong Li

Abstract—Airport gate assignment is of great importance in airport operations. In this paper, we study the Airport Gate Assignment Problem (AGAP), propose a new model and implement the model with Optimization Programming language 
(OPL). With the objective to minimize the number of conflicts of any two adjacent aircrafts assigned to the same gate, we build a mathematical model with logical constraints and the binary constraints, which can provide an efficient evaluation criterion for the Airlines to estimate the current gate assignment. To illustrate the feasibility of the model we construct experiments with the data obtained from Continental Airlines, Houston Gorge Bush Intercontinental Air-port IAH, which indicate that our model is both energetic and effective. Moreover, we interpret experimental results, which further demonstrate that our proposed model can provide a powerful tool for airline companies to estimate the efficiency of their current work of gate assignment. 

Keywords— Constraints, Gate Assignment, OPL, 
Optimization 

## I. Introduction

W
ith the development of economy, airports today become much busier and more complicated than previous days. Aircraft on the ground requires all kinds of diverse services, like reparation, maintenance and embarkation for passing-ers that has to be guaranteed within a very short time so that it must be in the right order. 

Growing flights congestion makes it necessary and compulsory to find ways to increase the airport operation efficiency. Research on airport gate assignment problem (AGAP) appears extremely significant on facilitating airlines to assess how many gates they should rent or purchase from airports to serve their own aircrafts (Lim & Wang 2005). Recently AGAP becomes one of core components in the field of airport resource management and naturally appeals the close concentration of current researchers (Chun etc. 1999). 

AGAP can be described as follows: Suppose an airline company owns the business of hosting a certain number of Manuscript received April 29, 2008. 

Chendong Li is with the Department of Computer Science, Texas Tech University, Lubbock, TX 79401 USA (phone: 806-742-3513 ext.236; fax: 
806-742-3519; e-mail: chendong.li@ttu.edu). 

fights every day and in order to run the business smoothly it must purchase or lease a certain number of gates from an airport. The main mechanism of flight-to-gate assignments is to assign aircraft to suitable gates so that not only passengers can conveniently embark or disembark but also the airline companies can minimize the cost in the whole operational process. Efficient airport operation largely depends on how to gate aircrafts in a smooth flow of arriving and departing flights. 

Different kinds of analytical models have been develop-ed on gate assignment problem, such as Mangoubi and Mathaisel 1985, Vanderstraetan 1988, Cheng 1997, Haghani and Chen 1998. At the same time, various techniques have been applied to solve this problem. For instance, linear binary programming (Babic 1984), 0 - 1 linear programming (Bihr 1990), genetic algorithm (Gu & 
Chung 1999), mixed 0 - 1 quadratic integer programming and tabu search (Xu & Bailey 2001), multi-objective programming (Yan & Huo 2001), simulated annealing 
(Ding 2002), stochastic programming (Lim & Wang 2005). Most of these techniques are employed to minimize the passenger's walking distance. 

The rest of the paper is organized as the follows. First, we formulate the problem employing the techniques of both constraint programming and linear programming with the objective to minimize the conflicts between any two adjacent aircraft assigned to the identical gate. Next, we describe the implementation and experiments with the data of Continental Airlines, Houston IAH airport under specified assumptions. Moreover, we interpret experimental results in detail, which further demonstrate the power and significance of our model. Finally, our conclusion is presented. 

## Ii. Problem Formulation

We formulate the airport gate assignment problem as the constraint resource assignment problem where gates serve as the limited resources and aircrafts play the role of resource consumers. 

 The operation constraints consist of two items: 1) 
every aircraft must be assigned to one and only one gate. Namely, for a given gate it can be occupied by one and only 