compute the auxiliary variable *yi,j* from *xi,k*. Equation (4) 
guarantees that one gate can only be assigned to one and only one aircraft at the same time. The scenario that there is an overlap between any two adjacent aircrafts is stated in this constraint. Some additional constraints in the real operations, such as that some particular aircrafts should be assigned to certain gates (like reserved gates and VIP gates), are out of consideration in the current formulated model. 

Equation (5) represents the decision variables, of which the value is binary. 

The proposed model can provide and efficient evaluation criteria for airlines to evaluate the current gate assignment. 

For example, if an airline authority wants to evaluate the efficiency of the gate assignment of certain number of flights (published as timetable or schedule for passengers' reference) at certain airport, he or she can calculate the value of the objective function in our proposed model based on the published schedule. Intuitively once the value is big, such as bigger than 10, it indicates that the current gate assignment is not good and the authority should consider the reassignment or modify current flight schedule. However, if the value is quite small, such as very near to 0, it denotes that the current gate assignment is almost the desired case in the scenario that the number of available gate is fixed at present. 

## Ⅲ. Implementation

Using the Optimization Programming Language we encode our model into OPLscript as shown in Fig.1 and run the program in ILOG OPL studio 3.7.1. In the OPLscript of Figure 1, arrtm, dptm, nbFlt, and nbGate stand for arriving time, departure time, number of Flight and number of Gate, respectively. 

We run our program on Dell server PE 1850 under the configuration of Intel(R)Xeon(TM) CPU 3.20GHz, 3.19G Hz, 2.00G of RAM. 

int nbFlt = ...; 
int nbGate = ...; 
range Gate 1 .. nbGate; range Flt 1 .. nbFlt; var int assign[Flt,Gate] in 0..1, int y[Flt,Flt] in 0..1; float+ arrtm[Flt] = ...; 
float+ dptm[Flt] = ...; 
minimize sum (i in Flt, j in Flt : arrtm[j] - dptm[i] >0 ) y[i,j] / (arrtm[j] - dptm[i]) subject to { 
 forall(i in Flt, j in Flt : i<>j ) sum(k in Gate)assign[i,k] * assign[j,k] = y[i,j]; forall(i in Flt) 
 sum(k in Gate) assign[i,k] = 1; forall(i in Flt, j in Flt, k in Gate : i<>j) 
 y[i,k]*y[j,k]*(arrtm[i] - dptm[j])*(arrtm[j] - dptm[i]) <= 0; 
 }; 
Fig.1 Assignment.mod 

## Ⅳ. Experiment

In this part we will describe how we conduct all the experiments and report relevant results. Before starting our formal experiment we first obtain the raw data and analyze the data especially due to the large data size. In the following steps, we run the program and collect the testing data. At the end of this part we refer to our future research directions to improve the experiment. 

A. *Data Analysis* We consider an airport with three gates and a schedule of six aircrafts first. To apply the proposed model, we first calculate the matrix of *E(p(i, j))* (we use the common accepted buffer time as b = 15 for illustration). 

In term of large date size, we choose the data of Continental Airlines as our raw data. Based on the timetable of Continental we extract the departure time of all the flights in a whole day, from 6:00A.M. to 23:59P.M., leaving from Houston George Bush International Airport -IAH. 

From the schedule, we obtain the departure time of 996 flights in all, in which we did not separate the real timetable that might be different from day to day. For instance, a certain fight may fly to a given destination on special days 