# Artificial Intelligence Techniques For Steam Generator Modelling

Sarah Wright and Tshilidzi Marwala Abstract **— This paper investigates the use of different** 
Artificial Intelligence methods to predict the values of several continuous variables from a Steam Generator. The objective was to determine how the different artificial intelligence methods performed in making predictions on the given dataset. 

The artificial intelligence methods evaluated were Neural Networks, Support Vector Machines, and Adaptive Neuro-Fuzzy Inference Systems. The types of neural networks investigated were Multi-Layer Perceptions, and Radial Basis Function.

Bayesian and committee techniques were applied to these neural networks. Each of the AI methods considered was simulated in Matlab. The results of the simulations showed that all the AI 
methods were capable of predicting the Steam Generator data reasonably accurately. However, the Adaptive Neuro-Fuzzy Inference system out performed the other methods in terms of accuracy and ease of implementation, while still achieving a fast execution time as well as a reasonable training time. 

Index Terms - Artificial Intelligence, Fuzzy Logic, NeuroFuzzy, Neural Networks, Support Vector Machines 

## I. I**Ntroduction**

A**rtificial Intelligence (AI) methods are concerned with**
machines or computer systems that have the ability to "learn" and solve problems, and as a result exhibit "intelligent" behaviour. Normally, intelligent behaviour is associated with characteristics such as having the ability to adapt, learn new skills, and form complex relationships [1]. There are several artificial intelligence methods that have been developed such as Neural Networks, Support Vector Machines, and NeuroFuzzy Systems. These AI systems have been utilised in different applications for example: pattern recognition, prediction of process variables, and various control applications. Each of these methods has different approaches to adapting and learning in order to emulate intelligent behaviour. Such Artificial Intelligence methods are particularly useful in modelling complex relationships where the relationship cannot be computed directly or easily interpreted by a human. 

A well known Artificial Intelligence method is Neural Networks. Neural networks are inspired by the mechanisms of the human brain and are capable of learning complex relationships through the association of examples of these relationships [2]. A neural network continuously adapts or adjusts these complex relationships found in an example dataset until it has learnt the relationships sufficiently well. 

Neural networks model these complex relationships in terms of a set of free parameters (weights and biases) that can be mathematically represented by a function [3]. There are numerous types of neural networks that can be implemented such as Radial Basis Function and Multi-layer Perceptions. 

Support Vector Machines is a more recent Artificial Intelligence method developed by Vapnik and his colleges' in 1992. Support Vector Machines are based on statistical learning where the goal is to determine an unknown dependency between a set of inputs and outputs, and this dependency is estimated from a limited set of example data 
[4]. In the case of classification, the idea is to construct a hyper-plane as a decision surface in such a way that the margin of separation between the different classes is maximized [5]. In the class of function approximation, the goal is to find a function that has at most a certain deviation from the desired target for all the points in a dataset of examples used to model such dependencies. Like neural networks, it models complex relationships using a mathematical approach. 

Neuro-Fuzzy Systems are based on Fuzzy logic which was formulated in the 1960s by Zadeh [6]. These systems combine Fuzzy Logic and certain principles of Neural Networks in order to model complex relationships. Fuzzy systems use a more linguistic approach rather than a mathematical approach, where relationships are described in natural language using linguistic variables [6]. 

All of the AI methods mentioned require a dataset in order to train the AI systems to be able to model the complex relationships of the system being modelled. Therefore, the AI 
system learns by example through a training process, and this dataset is called a training dataset. 

Most AI methods can be used for function approximation in which predictions of continuous variables can be generated. In this paper, the investigation into certain AI methods for the application of predicting certain variables from a Steam Generator will be discussed. The AI methods that were investigated were: Neural Networks (Radial Basis 