

![0_image_0.png](0_image_0.png)

![0_image_1.png](0_image_1.png)

A problem encountered with the RBF network implementation was that the training function for the RBF network in NETLAB (rbftrain) encounters a divide by zero error when the number of hidden nodes was substantially large and the code had to be modified if simulations were run with large number of hidden nodes. Alternatively, the training function for the MLP (netopt) could have been used for the RBF training; however, it no longer uses the 2 stage training process. 

A combination of early stopping and regularisation was used to determine theses optimum parameters. The values for alpha (weight decay coefficient) and beta (Inverse Noise ratio) were initially set to the default values. However, they didn't have to be changed significantly and were eventually set to 0.01 and 1 respectively. 

It was noticed that by adjusting either the hidden nodes or the number of training cycles, that different outputs contributed more to the overall error of the system (Equation 29). As a result, if an attempt was made to improve the network accuracy with respect to a certain output, it was found that the accuracy decreases with respect to one or more of the other outputs. The MLP is effectively trying to model 4 separate functions at once, therefore, the hidden nodes may have been having difficulty learning in order to model all 4 functions at the same time. This is referred to as cross-talk [2]. One way to attempt to solve this problem would be to model each output as a separate network [2]. 

For both the MLP and RBF, it was difficult to model Output 3. This can be seen from the Actual vs. Predicted plots of the first 60 data points for the testing dataset in Figures 9 and 13 for Output 3. An attempt was made to decrease the error contribution of Output 3 by adjusting the number of training cycles and hidden nodes. However, it made a small difference to the error that Output 3 contributed to the total error, and caused the contribution to the total error of the other outputs to increase. The neural networks did not seem to be able to model Output 3 as accurately as the other outputs of the system. A possible reason maybe that the dependency of Output 3 on the given inputs is weak, therefore, more input variables may need to be measured in order to model this output more accurately. The following performance measures were evaluated for each of the neural networks implemented: (i) the time taken to train the network using the training dataset, (ii) the time taken to execute or forward-propagate through the network for the testing dataset and (iii) the MSE accuracy obtained by the network on the testing dataset. The results are summarised in Table 1, for the optimum networks obtained for the RBF and MLP. The scaled conjugate gradient algorithm is used to optimise the MLP weights and biases. The RBF network with 30 hidden nodes is shown below as it has a comparable accuracy to the MLP obtained. 

| Table 1: Performance Characteristics for Individual MLP and RBF Networks   MLP RBF  Time to Train (s) 6.98 13  Time to Execute (s) 0.016 0.031  MSE of Test Dataset 0.075708 0.076360  No. of Hidden nodes 8 30  No. of Training Cycles 240 150   |
|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|

From Table 1, it can be seen that the RBF with comparable accuracy to the MLP took much longer to train. The complexity of the MLP and RBF with comparable accuracy is significantly different. The MLP has 8 hidden nodes corresponding to 76 free parameters while the RBF has 30 hidden nodes corresponding to 274 free parameters. While the RBF is supposed to be faster during the training process [2], the increased complexity of the network has increased the training time significantly. Both the MLP and RBF gave similar accuracy. The MLP was faster to execute than the RBF, which was expected. The plots for the Actual vs. Predicted values for the first 60 points for each output for the MLP are shown in Figures 7-10, and for the RBF in Figures 11-14. 