A neural network learns by example through training algorithms. Training results in an input/output relationship being determined for a specific problem. Training can be supervised or unsupervised. The neural networks discussed will use supervised training. Supervised training involves having a training dataset where numerous examples of inputs and their corresponding outputs (targets) are fed to the network. The weights and biases of the neural network are continuously adjusted to minimise the error between the network's outputs and the target outputs [2, 5, 7]. 

![0_image_0.png](0_image_0.png)

 Optimisation techniques can be used to determine the weights of the network, since it is a minimisation problem. Therefore, the knowledge or information about the problem is contained by the weights and biases of the network. 

An important property of neural networks is their ability to generalise. Generalisation refers to the ability of the neural network to predict or produce reasonable outputs for inputs not seen during the training or learning process [5]. Thus, the input/output relationship computed is valid for unseen data. Generalisation is influenced by the size of the training dataset and the architecture of the neural network [5].The best generalisation is normally achieved when the number of free parameters is fairly small compared to the size of the dataset [3]. However, a neural network can have poor generalisation if it is under-trained (under-fitting) or over-trained (overfitting). Over-training occurs when the neural network fits the training data perfectly and results with a function approximation or boundary line that is not smooth but erratic in nature [3]. The network effectively memorises the data and therefore, has poor generalisation on data not in the training set. Also, a neural network can be under-trained: there are not enough free parameters to sufficiently form an input/output relationship that captures the features of the problem [3]. 

## B. **Multi-Layer Perception**

Multi Layer Perception (MLP) neural networks are a popular class of feed-forward networks (Figure 2). They were developed from the mathematical model of the neuron (Figure 1), and consist of a network of neurons or perceptions [2]. An MLP network consists of an input layer (source data), several hidden layers of neurons, and an output layer of neurons. The hidden layers and the output layer can have different activation functions. There are various types of activation functions that can be employed. The activation function of the hidden neurons must be nonlinear and are usually functions that are differentiable [3]. Typically, the hyperbolic tangent or logistic functions are used for the activation function of the hidden neurons. However, the output activation function may be linear. Certain activation functions are more appropriate for different types of problems, therefore, the activation function needs to be selected according to the problem. Normally, a linear output activation function is used for regression problems as it does not limit the range of the output signal [2]. 

A multi-layer perception neural network represents a multivariate non-linear function mapping between a set of input and output variables [3]. It has been shown that any continuous function can be modelled accurately with one hidden layer, provided there is a sufficient number of hidden neurons [3, 5]. An MLP network with one hidden layer can be mathematically represented by Equation 2 [3]. 

$$y_{k}=f{\Biggl(}\sum_{j=1}^{N i b i d e n}w_{k j}^{(2)}f_{A}{\Biggl(}\sum_{i=1}^{N i p u a t}w_{j k}^{(1)}x_{i}\,+w_{j0}^{(1)}{\Biggr)}+w_{k0}^{(2)}{\Biggr)}\;\;\;(2)$$

where: 
k = number of outputs yk = the output at the kth **node** 
j = number of hidden neurons i = number of inputs fA **= activation function of the hidden neurons** 
f = activation function of the output neurons xi = the input from the ith **input node** 
wji **= weights connecting the input with the hidden** 
 nodes wjk **= weights connecting the hidden with the output** 
 **nodes** 

## W0J And W0K **= Biases**

The complexity of the model is related to the number of hidden units, as the number of free parameters (weights and biases) available to adjust is directly proportional to the number of hidden units. 

Training involves continuously adjusting the values of the weights and biases to minimise the error between the network's output and the desired targets. Initially, the weights and biases are set to random values, and then adjusted using an optimisation technique. However, such optimisation techniques are highly susceptible to finding local minima, and there is no guarantee that a global minimum has been found [3]. The best way to try and avoid a solution that is a local minimum is to train many networks taking the best network produced. 