
## C. **Radial Basis Functions**

Radial Basis Functions are two-layer feed-forward neural networks with the activation function of the hidden units being radial basis functions [5]. The response of the hidden layer unit is dependent on the distance an input is from the centre represented by the radial basis function (Euclidean Distance) [2]. Each radial function has two parameters: a centre and a width. Therefore, the maximum activation of a hidden unit is achieved when the input coincides with the centre vector. The width of the basis function determines the spread of the function and how quickly the activation of the hidden node decreases with the input being an increased distance from the centre [3]. The most common radial basis function used is the Gaussian bell-shaped distribution. 

Normally, an RBF only has one hidden layer, and a linear output layer. The input layer simply passes the input data to the hidden layer. An RBF network can be modelled mathematically by Equation 3 and the Gaussian activation function is represented by Equation 4. The bias parameters at the output layer compensate for the difference between mean output values and mean target values [3]. 

$$y_{k}\left(\mathbf{x}\right)=\sum_{j=1}^{M}w_{k j}\phi_{j}\left(\mathbf{x}\right)+w_{k0}$$
x φ x **(3)** 
$${\mathrm{where:}}$$

 M = number of hidden nodes 
the output at the $\mathrm{k}^{\mathrm{th}}$ node number of hidden nodes the weight factor from the $\mathrm{j}^{\mathrm{th}}$ hidden node to the $\mathrm{k}^{\mathrm{th}}$ output node 
$$\begin{array}{r}{y_{k}\,=\,}\\ {\mathbf{M}=\,}\\ {w_{k j}\,=\,}\\ {\,}\\ {w_{k0}=\,}\\ {\,}\\ {d_{i}\,=\,}\end{array}$$
 wk0 **= the bias parameter of the kth output node** 
φ **(x) = radial basis activation function** 
$$\phi_{j}\left(\mathbf{x}\right)=\exp\left\{{\frac{-\left\|\mathbf{x}-\mathbf{u}_{j}\right\|^{2}}{2\sigma_{j}^{2}}}\right\}$$ (4) ... 

$${\mathrm{where:}}$$
input vector  centre vector of the jth hidden node  width of basis function 
$$\mathbf{x}=$$ $$\mathbf{u}_{\mathrm{j}}=$$ $$\mathbf{\sigma}=$$

x = input vector 
 uj **= centre vector of the jth hidden node** 
 σ **= width of basis function** 
An RBF is trained in two stages. The first stage is an unsupervised learning process to determine the parameters of the radial basis function for each hidden node [3]. Therefore, only the input data is used during this process. These parameters are the centres and the widths of the basis functions. There are a number of unsupervised training algorithms to determine the parameters of the basis functions such as K-means clustering. The second stage involves finding the final layer weights that minimise the error between the network's output and the target values. Therefore, the second stage is done using supervised learning. Since the output layer is a linear function, the final layer weights can be solved using linear algebra [3]. Both of these stages are relatively fast, therefore, an RBF trains much faster than an equivalent MLP. The parameters of an RBF can be determined by supervised training. However, the optimisation process is no longer linear, resulting in the process being computationally expensive compared to the two stage training process. 

The main difference between MLPs and RBFs are that an MLP splits the input space into hyper-planes while an RBF splits the input space into hyper-spheres [2]. 

## D. **Committees**

Combining the outputs of several neural networks into a single solution to gain improved accuracy over an individual network output is called a committee or ensemble [8]. The simplest way of combing the outputs of different networks together is to average the outputs obtained [3]. The averaging ensemble can be expressed by Equation 5 [3, 8], 

$$y_{K}={\frac{1}{N}}\sum_{i=1}^{N}y_{K i}$$
= ∑ **(5)** 
$$(5)$$
$$({\mathfrak{I}})$$

where yk is the kth output, yki **is the kth output of network i,** 
and N is the number of networks in the committee. It can be shown that averaging the prediction of N networks reduces the sum-of-squares error by a factor of N [3]. However, this does not take into account that some networks in the committee may generate better predictions than others[3]. In this case, a weighted sum can be formulated in which certain networks contribute more to the final output of the committee [3]. There are several other committee methods to improve the accuracy of the prediction obtained, such as Bagging and Boosting. 

## E. **Bayesian Techniques For Neural Networks**

The training of the neural networks using the more standard approaches relies on the minimisation of a function error (Maximum Likelihood Approach) [3]. This approach makes defining the neural network model difficult, and both training and validation datasets are necessary to determine the model that exhibits the best generalisation. There will always be a certain error between the predicted and the actual. If several networks with identical architectures are produced with the same error, the weights and biases will not be the same each time, as there is a level of uncertainty in the training process due to there being many possibilities for parameters. 

In the Bayesian approach, a probability distribution function is considered to be represented over the weight space, to account for the uncertainty in determining the weight vector [3]. Instead of attempting to find a single set of weights that minimised the error between the predicted and actual values. The probability distribution represents the degree of confidence associated to the different values for the weight vector [3]. This probability distribution is initialised to some prior distribution, and then with the aid of the training 