dataset the posterior probability distribution can be determined and used to evaluate the predicted outputs for new input data points [3]. The posterior probability distribution can be expressed using Bayes' Theorem and is shown in Equation 6. 

$$P(w\,|\,D)={\frac{P(D\,|\,w)P(w)}{P(D)}}$$

## (6)

where D represents the target values of the training dataset, w is the vector representing the adaptive weights and biases, P(w) is the probability distribution function of the weight space in absence of any data points (Prior Probability Distribution), P(D) is a normalisation factor, P(D|w) is a likelihood function, and P(w|D) is the posterior probability distribution. Using Bayes' Theorem allows any prior knowledge about the uncertain weight values to be updated based on the knowledge gained from the training dataset to produce the posterior distribution of the unknown weight values [3]. The posterior probability distribution gives an indication of which weight values for the weight vector are most probable [3]. 

The prior probability distribution should take into account any information known about the weights [3]. From regularisation techniques, it's known that small weight values are favoured in order to produce smooth network mappings. Therefore, the weight-decay regularisation needs to be incorporated in the prior probability distribution function. For prior probability distribution that is a Gaussian function, the form is shown in Equation 6 [3], where W is the number of weights and Zw **is the normalisation coefficient. If the weight** 
decay term is small then the p(w) is large. The quantity α **is** 
the coefficient of weight-decay. 

$$P(w)=\frac{1}{Z_{w}(\alpha)}\exp(-\frac{\alpha}{2}\|w\|^{2})$$

where  2 2 w ZW     = α π

The Likelihood probability distribution is given by Equation 7, and is an expression of the difference between the predicted output ( *y(x,w)* ) and the target output (t**). The quantity** β **is** 
the coefficient of the data error [3]. 

$$P(D\,|\,w)=\frac{1}{Z_{D}(\beta)}\mathrm{exp}\!\left(-\frac{\beta}{2}\sum_{n=1}^{N}\left\{v\!\left(x^{n},w\right)\!-\!t^{n}\right\}^{2}\right)\;,$$
$$\mathrm{where~}Z_{D}=\left(\frac{2\pi}{\beta}\right)^{N_{2}^{\prime}}$$

The posterior probability distribution can be obtained by applying Bayes' theorem and is given below [3]. It can be seen that S(w) is dependent on the sum-of-squares error function and a weight regularisation term [3]. 

$$\begin{array}{c}{{=\frac{\beta}{2}\sum_{n=1}^{N}\left\{y\left(x^{n},w\right)-t^{n}\right\}^{2}+\frac{\alpha}{2}\sum_{i=1}^{W}w_{i}^{2}}}\\ {{Z_{s}\left(\alpha,\beta\right)=\int\exp\left(-\beta E_{D}-\alpha E_{W}\right)d w}}\end{array}$$
 
$$P(w\,|\,D)=\frac{1}{Z_{S}}\exp(-\,S(w))\tag{8}$$  where $S(W)=\beta E_{D}+\alpha E_{W}$
$$(9)$$

The training process for the Bayesian approach involves determining the appropriate posterior probability distribution of the weight values [9]. In order, to make a prediction for a new input vector, the output distribution must be computed, and is given by Equation 9. This Equation is effectively taking an average prediction of all the models weighted by their degree of probability [3], and is dependent on the posterior probability distribution. Therefore, the trained network can make predictions on input data it has not seen by using the posterior probability distribution. 

$$P(y^{n+1}\,|\,x^{n+1},D)=\int P(y^{n+1}\,|\,x^{n+1},w)P(w\,|\,D)d w$$

The evaluation of the probability distributions requires integration over a multidimensional weight space, and is not easily handled analytically. One method to evaluate the integrals is to use a Gaussian Approximation which allows the integral to be analytically evaluated using optimisation techniques [3]. Another common method used to solve these type of integrals is a random sampling method called Monte Carlo Technique [10]. Therefore, the Monte Carlo or the Hybrid Monte Carlo method is normally used to identify the posterior probability distribution of the weights for a Bayesian neural network, by sampling from the posterior weight distribution. 

## F. **Monte Carlo Methods**

In the Bayesian approach to neural networks, integration plays a significant role as calculations involve evaluating an integral over the weight space. Monte Carlo is a method of approximating the integral by using a sample of points from the function of interest [3]. The integrals that need to be evaluated are of the form [3], 