
## I = ∫ F(W)P(W| D)Dw (10)

where F(w) is the integrand and P(w|D) is the posterior distribution of weights. This integral can then be approximated using a finite sum of the form, 

$$I\approx{\frac{1}{L}}{\sum_{i=1}^{L}}F(w_{i})$$

where wi **is the sample of weight vectors generated from the** 
posterior probability distribution [3]. In order to generate samples of the weight vector space representative of the P(w|D), a random search through the weight space for areas were the distribution is reasonably large is performed. This done using a technique called Markov Chain Monte Carlo, where a sequence of weight vectors are generated, each new vector in the sequence depending on the previous weight vector plus a random component [3]. A random walk is the simplest method in which each successive step is computed using Equation 12 [3]. 

$$\begin{array}{c}{{w_{_{n+1}}=w_{_{n}}+\varepsilon}}\\ {{(12)}}\end{array}$$

ε **is a random vector that allows more of the weight space to** 
be explored. In order, to find samples of weight vectors that are representative of the P(w|D) distribution, a procedure known as the Metropolis Algorithm is used to select the sample weight vectors. The Metropolis Algorithm rejects or accepts a certain sample of the weight space or state generated using Equation 12 based on the following conditions, 

$$w_{n+1}\mid D\rangle<P(w_{n}\mid D)\;\mathrm{accept}\;\mathrm{state}\;w_{n+1}$$  with probability $\frac{P(w_{n+1}\mid D)}{P(w_{n}\mid D)}$
P w D P w D w
_if $P(w_{n+1}\mid D)<P(w_{n}\mid D)$_ accept state $w_{n+1}$
+ +
>
 if ( | ) ( | ) **accept state**
n n n
$$\mathrm{{lept~state}}\,w_{n+1}$$
1 1
Using the above conditions, certain of the weight vector samples will be rejected if they lead to a reduction in the posterior distribution [3]. This procedure is repeated a number of times until the necessary number of samples are produced for the evaluation of the finite sum for the integral. Due to high correlation in the posterior distribution as a result of the each successive step being dependent on the previous, a large number of the new weight vector states will be rejected [3]. Therefore, a Hybrid Monte Carlo method can be used instead. 

The Hybrid Monte Carlo methods uses information about the gradient of P(w|D) to ensure that samples through the areas of higher posterior probabilities are favoured [3]. This gradient information can be obtained through the backpropagation algorithm. The Hybrid Monte Carlo method is based on the principles of Hamiltonian mechanics that describe molecular dynamics [10]. It is a form of the Markov Chain, however, the transition between states is achieved using the stochastic dynamic model [9]. In statistical mechanics, the state space of a system at a certain time can be described by the position and momentum of all the molecules of the system at that time [9]. The position defines the potential energy of the system and the momentum defines the kinetic energy of the system [9-10]. The total energy of the system is the sum of the potential and kinetic energy, and can be represented by the Hamiltonian equation defined as, 

$$H(w,p)=E(w)+K(p)=U(w)+\frac{1}{2}\sum_{i}p_{i}^{2}\tag{13}$$

 where w is the position variable, p is the momentum variable, H(w,p) is the total energy of the system, E(w) is the potential energy, and K(p) is the kinetic energy. The positions are analogous with the weights of a neural network, and potential energy with the network error [10]. In this equation, the energies of the system are defined by energy functions representing the state of the physical system (canonical distributions) [10]. In order to obtain the posterior distribution of the network weights, the following distribution is sampled ignoring the distribution of the momentum vector [9]. 

$$P(w,p)={\frac{1}{Z}}\exp(-H(w,p))$$
$$(14)$$

Hamiltonian dynamics are used to sample at a fixed energy in terms of a fictitious time τ **[9-10], and are shown in Equation** 
15 and 16. Since the dynamics shown in Equations 15 and 16 can not be simulated exactly, the equations are discretised using finite time steps given by Equation 17 and 19. [10]. In this way the position and momentum at time τ + ε **is** expressed in terms of the position and momentum at time τ
[10]. This method is known as the leap-frog method. These new states are accepted or rejected using the Metropolis criterion. 

$${\frac{d w_{i}}{d\tau}}={\frac{\partial H}{\partial p_{i}}}=p_{i}$$
$$(15)$$

$${\frac{d p_{i}}{d\tau}}=-{\frac{\partial H}{\partial w_{i}}}=-{\frac{\partial E}{\partial w_{i}}}$$
$$(16)$$
