Discretise d *Equations*

$$\hat{p}_{i}\!\left(\tau+\frac{\epsilon}{2}\right)=\hat{p}_{i}\!\left(\tau\right)-\frac{\epsilon}{2}\frac{\partial E}{\partial w_{i}}\!\left[\hat{w}_{i}\!\left(\tau\right)\right]\tag{17}$$

$$\hat{w_{i}}\left(\tau+\varepsilon\right)=\hat{w_{i}}\left(\tau\right)+\varepsilon\hat{p_{i}}\left(\tau+\frac{\varepsilon}{2}\right)$$  $$\hat{p_{i}}\left(\tau+\varepsilon\right)=\hat{p_{i}}\left(\tau+\frac{\varepsilon}{2}\right)-\frac{\varepsilon}{2}\frac{\partial E}{\partial w_{i}}\left[\hat{w_{i}}\left(\tau+\varepsilon\right)\right]$$

The basic steps in the implementation of the Hybrid Monte Carlo algorithm are [9, 11]: 
(i) Randomly choose a trajectory direction (λ) where λ **is -1** for a backward trajectory and +1 for a forward trajectory. 

(ii) Starting from a current state (w, p). Perform L leapfrog steps with the step size ε **using Equations 16-19 to product a** 
candidate state (w*, p*). Performing L leapfrog steps allows more of the state space to be explored faster. (iii) Using the Metropolis criterion, accept or reject the (w*, p*) state. If the candidate state is rejected the old state (w, p) is kept as the new state. Otherwise, the candidate state is accepted and it becomes the new state. 

## Iv. Support Vector **Machines**

Support Vector Machines (SVM) were introduced by Vapnik and his colleges in 1992. They are based on statistical learning theory and are one type of kernel learning algorithm in the field of machine learning [4]. SVMs can be used for both classification and regression problems. The goal of statistical learning is to determine an unknown dependency between a set of inputs and outputs, and this dependency is estimated from a limited set of example data. [4]. Therefore, the objective of a SVM, like neural networks, is to produce a model which can predict the output values of a dataset previously unseen. Thus, SVMs utilise supervised learning techniques, and require a training and testing dataset. 

In the case of classification, the idea is to construct a hyper-plane as a decision surface in such a way that the margin of separation between the different classes is maximized [5]. These decision planes are defined to act as decision boundaries separating different classes of objects. 

$$(18)$$

![0_image_0.png](0_image_0.png)

$$(19)$$

In support vector regression, the idea is to find a function that has at most a deviation of ε **from the desired targets for all** the training data (ε **-SV regression) [12]. Thus, errors below** the deviation are not of concern, and points outside this deviation are penalized (Refer to Figure 3). Therefore, a function that approximates all the input-output pairs with the defined precision must actually exist and the optimisation required must be able to be feasibly solved [12]. In order, to account for data points that cannot be easily modelled, slack variables are normally introduced.

In both classification and regression, the inputs are mapped into a higher dimensional feature space by a function φ **(x)** 
induced by a kernel function [4, 12]. The SVM then finds a linear separating hyper-plane with the maximal margin in this higher dimensional space for the classification case, and a set of linear functions in this higher dimensional space for the regression case [4, 13]. There are different types of kernel functions: linear, polynomial, radial basis function (RBF), and sigmoid. Any function that satisfies Mercer's Theorem can be used as a kernel function [4]. The kernel function is equal to the inner product of the two vectors (input vector (x) 
and input pattern of the ith training sample (xi**)) induced in** 
the feature space and is given by Equation 20 [5]. 

## ( , ) ( ) ( ) I T I K X X = Φ X Φ X (20)

In the case of regression, if given a training dataset, {(xi, ti)} N
i=1
, where the x is the input vector and t **is the target value,** 
an SVM approximates the function using Equation 21 [13]. 

## Y = F (X) = Wφ(X) + B (21)

where φ **(x) represents the higher dimensional feature space** 
that the inputs are mapped to, w is the weight vector, and b is the bias. Since in reality, not every point will be able to fit within the deviation defined, the Support Vector Machine minimises the number of points outside the deviation using a penalty parameter [12]. This is achieved by minimising Equation 22. If Equation 22 is transformed into dual formulation, it is expressed in terms of the kernel function 