order to model complex relationships. Fuzzy systems use a more linguistic approach rather than a mathematical approach, where relationships are described in natural language using linguistic variables. **Fuzzy Logic can deal** with ill-defined, imprecise systems [16], and therefore are a good tool for system **modelling. This section introduces the** 
basics of Fuzzy Logic and then explains Adaptive NeuroFuzzy Inference Systems that are based on the foundations of Fuzzy Logic. 

## A. **Basic Fuzzy Logic Theory**

Fuzzy logic is a method of mapping an input space to an output space by means of a list of linguistic rules that consist of if-then statements [6]. Fuzzy logic consists of 4 components: fuzzy sets, membership functions, fuzzy logical operators, and fuzzy rules [6, 17, 18]. 

In classical set theory, an object is either a member or is not a member of specific set [17-18]. Therefore, it is possible to determine if an object belongs to a specific set as a set has clear distinct boundaries, provided an object cannot achieve partial membership. Another way of thinking about this is that the object's belonging to a set is either true or false. A characteristic function for a classical set has a value of 1 if the object belongs to the set and a value of zero if the object doesn't belong to the set [17]. For example, if a set X is defined to represent all possible heights of people, one could define a "tall" subset for any person who is above or equal to a specific height x, and anyone below x **doesn't belong to the** 
"tall" set but to a "short" subset. This is clearly inflexible as a person just below the boundary is labelled as being short when they are clearly tall to some degree. Therefore, intermediate values such as fairly tall are not allowed. Also, these clear cut defined boundaries can be very subjective in terms of what a person may define as belonging to a specific set. 

The main aim behind fuzzy logic is to allow a more flexible representation of sets of objects by using a fuzzy set. A fuzzy set does not have as clear cut boundaries as a classical set, and the objects are characterized by a degree of membership to a specific set [17-18]. Therefore, intermediate values of objects can be represented which is closer to the way the human brain thinks opposed to the clear cut-off boundaries in classical sets. A membership function defines the degree that an object belongs to a certain set or class. The membership function is a curve that maps the input space variable to a number between 0 and 1, representing the degree that a specific input variable belongs to a specific set [17-18]. A membership function can be a curve of any shape. Using the example above, there would be two subsets one for tall and one for short that would overlap. In this way a person can have a partial participation in each of these sets, therefore, determining the degree to which the person is both tall and short. 

Logical operators are defined to generate new fuzzy sets from the existing fuzzy sets. In classical set theory there are 3 main operators used, allowing logical expressions to be defined: intersection, union, and the complement [17]. These operators are used in fuzzy logic, and have been adapted to deal with partial memberships. The intersection (AND operator) of two fuzzy sets is given by a minimum operation, and the union (OR operator) of two fuzzy sets is given by a maximum operation [17]. These logical operators are used in the rules and determination of the final output fuzzy set.

Fuzzy Rules formulate the conditional statements which are used to model the input-output relationships of the system, and are expressed in natural language [6]. These linguistic rules are in the form of if-then statements which use the logical operators and membership functions to produce an output. An important property of fuzzy logic is the use of linguistic variables. Linguistic variables are variables that take words or sentences as their values instead of numbers [17]. Each linguistic variable takes a linguistic value that corresponds to a fuzzy set [17], and the set of values that it can take is called the term set [18]. For example, a linguistic variable *Height* **could have the following term set** {*very tall, tall, medium, short, very short}***. A single fuzzy** rule is of the form: 

## If X Is A Then Y Is **B (25)**

where A and B are fuzzy sets defined for the input and output space respectively. Both x and y are linguistic variables, while A and B are the linguistic values or labels represented by the membership functions [16]. Each rule consists of two parts: the antecedent and the consequent [17]. The antecedent is the component of the rule falling between the if-then, and maps the input x to the fuzzy set A, using a membership function. The consequent is the component of the rule after the then, and maps the output y to a membership function. The input membership values act like weighting factors to determine their influence on the fuzzy output sets [17]. A fuzzy system consists of a list of these if-then rules which are evaluated in parallel. The antecedent can have more than one linguistic variable, these inputs are combined using the AND operator. 

Each of the rules is evaluated for an input set, and corresponding output for the rule obtained. If an input corresponds to two linguistic variable values then the rules associated with both these values will be evaluated. Also, the rest of the rules will evaluated, however, will not have an effect on the final result as the linguistic variable will have a value of zero. Therefore, if the antecedent is true to some degree, the consequent will have to be true to some degree [17]. The degree of each linguistic output value is then computed by performing a combined logical sum for each membership function [17]. After which all the combined sums for a specific linguistic variable can be aggregated. These last stages involve the use of an inference method which will map the result onto an output membership function [19]. Finally, a defuzzification process is preformed in which a single numeric output produced. One method of computing the degree of each linguistic output value is to take the maximum of all rules describing this linguistic output value [17, 19], and the output is taken as the centre of gravity 