since the aggregate is nonmonotone, it can also be written as nested expression
¬(p ∧ q) ∧ ¬p ∧ ¬q, which is strongly equivalent to ¬p ∧ ¬q.

On the other hand, if an aggregate is neither monotone nor antimonotone, it may be not possible to find a nested expression strongly equivalent to (9), even if F1, . . . , Fn are nested expressions. This is the case for (7). Indeed, the formula (9)
corresponding to (7) is (10), whose reduct relative to {p, q} is (10). Consequently, by Proposition 5, for any formula G strongly equivalent to (10), G{p,q}is classically equivalent to (10). On the other hand, the reduct of nested expressions are essentially AND-OR combinations of atoms, ⊤ and ⊥ (negations either become ⊥ or ⊤ in the reduct), and no formula of this kind is classically equivalent to (10).

In some uses of ASP, aggregates that are neither monotone nor antimonotone are essential, as discussed in the next section.

## 3.4 Example

We consider the following variation of the combinatorial auction problem [Baral and Uyan, 2001],
which can be naturally formalized using an aggregate that is neither monotone nor antimonotone.

Joe wants to move to another town and has the problem of removing all his bulky furniture from his old place. He has received some bids: each bid may be for one piece or several pieces of furniture, and the amount offered can be negative (if the value of the pieces is lower than the cost of removing them). A junkyard will take any object not sold to bidders, for a price. The goal is to find a collection of bids for which Joe doesn't lose money, if there is any.

Assume that there are n bids, denoted by atoms b1, . . . , bn. We express by the formulas bi ∨ ¬bi (17)
(1 ≤ i ≤ n) that Joe is free to accept any bid or not. Clearly, Joe cannot accept two bids that involve the selling of the same piece of furniture. So, for every such pair i, j of bids, we include the formula

$\neg(b_i\wedge b_j)$... 
¬(bi ∧ bj ). (18)
Next, we need to express which pieces of the furniture have not been given to bidders. If there are m objects we can express that an object i is sold by bid j by adding the rule bj → si (19)