Weight constraints are expressions of the form

$$(21)$$
$$N\leq\{l_{1}=w_{1},\ldots,l_{m}=w_{m}\}$$
$$(22)$$
and
$$\{l_{1}=w_{1},\ldots,l_{m}=w_{m}\}\leq N$$

where
- N is (a symbol for) a real number,
- each of l1, . . . , ln is a (symbol for) a literal, and w1, . . . , wn are (symbols for) real numbers.

An example of a weight constraint is (1).

The intuitive meaning of (21) is that the sum of the weights wi for all the li that are true is not lower than N. For (22) the sum of weights is not greater than N. Often, N1 ≤ S and S ≤ N2 are written together as N1 ≤ S ≤ N2. If a weight w is 1 then the part "= w" is generally omitted. If all weights are 1 then a weight constraint is called a *cardinality constraint*.

A rule with weight constraints is an expression of the form

$\eqref{eq:walpha}$. 
$$a\gets C_{1}\land\cdots\wedge C_{n}$$
a ← C1 **∧ · · · ∧** Cn (23)
where a is an atom or ⊥, and C1, . . . , Cn (n ≥ 0) are weight constraints.

Finally, a program with weight constraints is a set of rules with weight constraints. Rules/programs with cardinality constraints are rules/programs with weight constraints containing cardinality constraints only.

Programs with cardinality/weight constraints can be seen as a generalization of traditional programs, by identifying each literal l in the body of each rule with cardinality constraint 1 ≤ {l}.

The definition of a stable model from [Niemel¨a and Simons, 2000] requires first the elimination of negative weights from weight constraints. This is done by replacing each term li = wi where wiis negative with li = −wi (liis the literal complementary to li) and increasing the bound by −wi. For instance,

$$0\leq\{p=2,q=-1\}$$
is rewritten as
$$1\leq\{p=2,\neg q=1\}.$$

Then [Niemel¨a and Simons, 2000] proposes a definition of a reduct and of a stable model for programs with weight constraints without negative weights. For