On top of arbitrary propositional formulas, we give our definition of an aggregate. Our extension of the semantics to aggregates treats aggregates in a way similar to propositional connectives. Aggregates can be viewed either as primitive constructs or as abbreviations for propositional formulas; both approaches lead to the same concept of a stable model. The second view is important because it allows us to use theorems about stable models of propositional formulas in the presence of aggregates. As an example of application of such theorems, we use them to prove the correctness of an ASP program with aggregates that encodes a combinatorial auction problem.

Syntactically, our aggregates can occur in any part of a formula, even nested inside each other. (The idea of "nested aggregates" is not completely new, as the proof of Theorem 3(a) in [Ferraris, 2007] involves "nested weight constraints".)
In our definition of an aggregate we can have, in the same program/theory, many other kinds of constructs, such as choice rules and disjunction in the head, while other definitions allow only a subset of them. Our aggregates seems not to exibit the unintuitive behaviours of other definitions of aggregates.

It also turns out that a minor syntactical modification of programs with FLPaggregates allows us to view them as a special kind of our aggregates. (The new picture of extensions is shown in Figure 2.) Consequently, we also have a "propositional" representation of FLP-aggregates. We use this fact to compare them with other aggregates that have a characterization in terms of nested expressions. (As we said, [Ferraris and Lifschitz, 2005b] showed that weight constraints can be expressed as nested expressions, and also [Pelov *et al.*, 2003] implicitly defined PDBaggregates in terms of nested expressions.) We will show that all characterizations of aggregates are essentially equivalent to each other when the aggregates are monotone or antimonotone and without negation, while there are differences in the other cases.4 The paper is divided into three main parts. We start, in the next section, with the new definition of a stable model for propositional theories, their properties and comparisons with previous definitions of stable models and equilibrium logic. In Section 3 we present our aggregates, their properties and the comparisons with other definitions of aggregates. Section 4 contains all proofs for the theorems of this paper. The paper ends with the conclusions in Section 5.

Preliminary reports on some results of this paper were published in [Ferraris, 2005].