
## 2 Stable Models Of Propositional Theories 2.1 Definition

Usually, in logic programming, variables are allowed. As in most definitions of a stable model, we assume that the variables have been replaced by constants in a process called "grounding" (see, for instance, [Gelfond and Lifschitz, 1988]), so that we can consider the signature to be essentially propositional.

(Propositional) formulas are built from atoms and the 0-place connective ⊥
(false), using the connectives ∧, ∨ and →. Even if our definition of a stable model below applies to formulas with all propositional connectives, we will consider ⊤
as an abbreviation for **⊥ → ⊥**, a formula ¬F as an abbreviation for F → ⊥ and F ↔ G as an abbreviation for (F → G) ∧ (G → F). This will keep notation for other sections simpler. It can be shown that these abbreviations perfectly capture the meaning of ⊤, ¬ and ↔ as primitive connectives in the stable model semantics.

A *(propositional) theory* is a set of formulas. As usual in logic programming, truth assignments will be viewed as sets of atoms; we will write X |= F to express that a set X of atoms satisfies a formula F, and similarly for theories.

An implication F → G can be also written as a "rule" G ← F, so that traditional programs, disjunctive programs and programs with nested expressions (reviewed in Section 2.2) can be seen as special cases of propositional theories.5 We will now define when a set X of atoms is a stable model of a propositional theory Γ. For the rest of the section X denotes a set of atoms.

The *reduct* F
X of a propositional formula F relative to X is obtained from F by replacing each maximal subformula not satisfied by X with ⊥. That is, recursively,
- ⊥X = ⊥;
- for every atom a, if X |= a then a X is a, otherwise it is ⊥; and
- for every formulas F and G and any binary connective ⊗, if X |= F ⊗ G
then (F ⊗ G)
X is F
X ⊗ GX , otherwise it is ⊥.

This definition of reduct is similar to a transformation proposed in [Osorio *et al.*, 2004, Section 4.2].

5Traditionally, conjunction is represented in a logic program by a comma, disjunction by a semicolon, and negation as failure as not.