
| kind of rule            | syntax                            |                                  |
|-------------------------|-----------------------------------|----------------------------------|
| traditional             | a ← l1 ∧ · · · ∧ ln               |                                  |
| disjunctive             | a1 ∨ · · · ∨ am ← l1 ∧ · · · ∧ ln |                                  |
| with nested expressions | F ← G                             | (F and G are nested expressions) |

Figure 3: Syntax of "propositional" logic programs. Each a, a1, . . . , am (m ≥ 0)
denotes an atom, and each l1, . . . , ln (n ≥ 0) a literal - an atom possibly prefixed by ¬. A *nested expression* is any formula that contains no implications other than negations or ⊤.

the stable model semantics says that only sets of atoms that don't contain both atoms a and ∼a can be stable models. For simplicity, we will make no distinctions between positive and negative atoms, considering that we can remove the sets of atoms containing any pair of atoms a and b from the stable models of a theory by adding a formula ¬(a ∧ b) to the theory. (See Proposition 7).

## 2.2 Relationship With Previous Definitions Of A Stable Model

As mentioned in the introduction, a propositional theory is the extension of traditional programs [Gelfond and Lifschitz, 1988], disjunctive programs [Gelfond and Lifschitz, 1991]
and programs with nested expressions [Lifschitz *et al.*, 1999] (see Figure 2). We want to compare the definition of a stable model from the previous section with the definitions in the three papers cited above.

The syntax of a traditional rule, *disjunctive rule* and *rule with nested expressions* are shown in Figure 3. We understand an empty conjunction as ⊤ and an empty disjunction as ⊥, so that traditional and disjunctive rules are also rules with nested expressions. The part before and after the arrow ← are called the *head* and the *body* of the rule, respectively. When the body is empty (or ⊤), we can denote the whole rule by its head. A *logic program* is a set of rules. If all rules in a logic program are traditional then we say that the program is *traditional* too, and similarly for the other two kinds of rules.

For instance, (3) is a traditional program as well as a disjunctive program and a program with nested expressions. On the other hand, (4) is not a logic program of any of those kinds, because of the first formula that contains implications nested in a disjunction.

For all kinds of programs described above, the definition of a stable model is similar to ours for propositional theories: to check whether a set X of atoms is a stable model of a program Π, we (i) compute the reduct of Π relative to X, and (ii) verify if X is a minimal model of such reduct. On the other hand, the way in which the reduct is computed is different. We consider the definition