# Identification Of Parameters Underlying Emotions And A Classification Of Emotions

N. Arvind Kumar arvind.kumar@gmail.com October 26, 2018

## Abstract

The standard classification of emotions involves categorizing the expression of emotions. In this paper, parameters underlying some emotions are identified and a new classification based on these parameters is suggested.

## 1 Introduction

Widely accepted classifications of emotions classify them by the expression of emotions. Paul Ekman has proposed a list of basic emotions and has considered the expression of the emotion as a characteristic of the emotion [1]. The list includes anger, fear, sadness, enjoyment, disgust and surprise. Another classification by Robert Plutchik also classifies emotions based on the **external** expression of emotions. Marvin Minsky states that "emotion is one of those suitcase like words that we use to conceal the complexity of very large ranges of different things." [2]
The approach in this paper does not attempt to identify basic emotions, but is in alignment with Minsky's argument about the complex nature of emotions. It deviates from the method of classifying emotions based on the expression of emotions. Instead, the underlying parameters that result in an **emotion are** taken into consideration for the purpose of organizing various emotions. One of the biggest challenges in categorizing emotions in this manner is that the brain must observe itself and separate out the various strands that are part of the complex mental process that is observed. It is not an easy task to **identify the** individual strands of the complex process. Even when the individual **strands** are identified, it is not easy to determine the particular mental process to which they belong.

## 2 Classification Of Emotions

Emotions depend on attachments or repulsion (negative attachments) to certain states or desired states and emotions would not exist in the absence of such attachments. There are other parameters apart from an attachment that go into the formation of an emotion. These parameters are used here to differentiate emotions from each other.