# Prediction Of Platinum Prices Using Dynamically Weighted Mixture Of Experts

Baruch Lubinsky, Bekir Genc and Tshilidzi Marwala University of the Witwatersrand Private Bag x3 Wits, 2050, South Africa Abstract**—Neural networks are powerful tools for** 
classification and regression in static environments. This paper describes a technique for creating an ensemble of neural networks that adapts dynamically to changing conditions. The model separates the input space into four regions and each network is given a weight in each region based on its performance on samples from that region. The ensemble adapts dynamically by constantly adjusting these weights based on the networks' current performance. The dataset used is a collection of financial indicators with the goal of predicting the future platinum price. An ensemble with no weightings does not improve on the naive estimate of no weekly change; our weighting algorithm gives an average percentage error of 63 % for twenty weeks of prediction. 

## Index Terms**—Adaptive Estimation, Multilayer Perceptron,** Neural Networks, Platinum, Prediction Methods I. I**Ntroduction**

Neural networks are known to be powerful tools for predicting future values of a time series [1]. Neural network regression is especially powerful in cases where simple linear regression is ineffective due to the non linear nature of the system [2]. One such system is the financial market, in which accurate predictions are difficult to make. This paper examines a neural network technique used to forecast the price of platinum. 

This paper demonstrates the advantage gained by spatially dividing an input space. That is separating the input into different regions and giving each member of an ensemble a weight in each network. These weights are then extended to be functions of time in the study of platinum price predictions. 

The approach taken gives positive results with a relatively high accuracy of prediction to this notoriously difficult problem [3]. A mixture of experts is used in order to cover the diverse factors that affect the future price of platinum. The voting weight allocated to each hypothesis is updated after each test sample. This dynamic weighting is a novel approach to the problem and is shown to greatly increase the accuracy of the ensemble. 

II. MIXTURE OF E**XPERTS**
The power of a neural network to make predictions can be greatly increased by combining the output of a number of networks collected in an ensemble [4]. For cases where the system is too complex to be learned by a single network, a mixture of experts can be used. Each network can correctly learn some feature of the system. These networks can then be combined to provide a model for the whole system. The method of combining the networks will depend on the nature of the data being modeled [5]. 

III. SPATIAL DIVISION OF INPUT S**PACE**
One method of combining the outputs of the networks in an ensemble is to simply take the mean of all the outputs. However this does not take advantage of the fact that each network may have learned a different feature of the dataset. 

Any input space can be divided spatially along different features to create regions in the input space [6]. The performance of each expert can then be judged per region. Each network is assigned a numerical weight in each region. Then the output of the ensemble is the weighted average of the each network's output [7]. Consider an ensemble made up of networks k f **with corresponding** 
weights w (*region* )
k**. For a given input** x r in region i **the** 
prediction of the ensemble is: 

$$y={\frac{\sum_{k}f_{k}({\bar{x}})w_{k}(i)}{\sum_{k}w_{k}(i)}}$$
$$\mathrm{(1)}$$

r
 (1) 
Thus the contribution of the networks with the highest weights will have the greatest impact on the value of the output. The weights are initially defaulted to a value of 1. When all the weights are 1, the output is simply the mean of the output of each network. 

## A. Preliminary Testing

This method of dividing the input space into different regions is tested on a sample dataset, created using PRTools [8]. Figure 1 shows an example of the "Banana" dataset generated by PRTools. The different markers represent the two classes to be classified. 

The classifier used is an ensemble of multi-layer perceptron (MLP) neural networks. The dataset is divided into 150 and samples for training and 50 for testing. Using different data points for testing than training ensures that the generalization ability of the ensemble is tested and that the classifier does not over fit to the training samples. 

Figure 1 shows the different regions of the input space, separated by the dashed lines. The regions are created by separating both axes by the median of the feature. Each 