network has a vector of weights corresponding to each 

![0_image_0.png](0_image_0.png) region. These weights are adjusted during training. For each sample, if the network classifies correctly, the relevant weight is multiplied by 1.2 otherwise it is multiplied by 0.4. These values are found to give weights that are constrained to reasonable values. When the ensemble is tested, the output is then the weighted average of the output of each network, according the weights calculated. 

The accuracy of the ensemble is tested 100 times to obtain a meaningful average for four different weighting schemes. The test is run for networks with no weights (all weights are 1) and the decision is simply the mean of all the outputs. A small improvement is gained by giving each network one weight corresponding to its overall performance. Then the input space is divided into two regions by only dividing on one feature with two weights, and then four regions. The results are shown in table I, accuracy is the number of correct classifications over the total number of test samples. 

TABLE I 
C**LASSIFIER ACCURACY WITH DIFFERENT WEIGHTINGS**
Test **Accuracy**
No weights **82.92** %
1 weight **83.50** %
2 weights **86.24** % 4 weights **88.18** %
These results show that the performance of an ensemble is improved by giving more strength to the output of a network that has better accuracy. The performance of the ensemble is improved even further when the input space is divided and weights are assigned for each region. These regions need not divide the different classes perfectly to be effective. The regions in figure 1 are separated along the median of each feature which proves to be an adequate method for defining the regions. This test shows that the divisions in the input space need not represent any complex feature of the dataset. This relatively simple data demonstrates the power of weighting the different experts in an ensemble as a function of the position of the input. 

## Iv. Dynamic W**Eighting**

The previous section describes an effective method of combining a number of neural networks into an ensemble with significantly improved performance. However, the data in that example - or more importantly the function that generates them - is stationary. We are interested in data being drawn from a dynamic environment. In this case, it is not sufficient to train the networks and combine them in an ensemble. The factors which generated the training data are unlikely to be present at the time of testing. The ensemble needs to adapt to changing conditions. 

The concept of spatial weightings is extended for time series such that the weightings change as a function of time [9]. The weight for each region is updated after each sample. This is possible for time series in which, as each sample is received, the correct output for the previous sample becomes known. Adjusting the weights in this manner is a powerful method of implementing an adaptive model of a system. At each time step, the ensemble is updated without retraining each network. If we assume that the factors governing a system vary slowly within some bounded space, an ensemble with dynamic weights can retain its accuracy over time even as the system changes. Such a model can adapt continuously provided the conditions of the system were encountered in training. Thus effective adaptation is achieved, without the cost of retraining the ensemble. 

## A. Platinum Price Case Study

An example of a system that displays the characteristics described above is the platinum price. This is a notoriously difficult system to model due to the vast range of factors that impact it [3]. However, these factors are limited within a reasonable scope. The price of platinum is used here as an example to illustrate the power of dynamic weighting to make predictions in a complex system. 

1) Neural Network Structure: **Each expert in the** 
ensemble is a MLP neural network. The network takes as its input the current market trends and the output is the prediction for the future change in platinum price. The inputs are the prices of platinum, palladium, radium, gold and Brent Crude and the South African Rand to US Dollar exchange rate as these are considered to be the best indicators [3]. The data is smoothed by taking weekly averages and then normalized by considering the percentage change for each week. The inputs are the changes during the previous week. The correct output is the percentage change in platinum price during the subsequent week. 

Individual networks are trained by the Markov Chain Monte Carlo (MCMC) method [10]. The weights of the network are initialized randomly and then adjusted in small 