# Approximate Inference On Planar Graphs Using Loop Calculus And Belief Propagation

Vicen¸c G´omez v.gomez@science.ru.nl Hilbert J. Kappen b.kappen@science.ru.nl Department of Biophysics Radboud University Nijmegen 6525 EZ Nijmegen, The Netherlands Michael Chertkov chertkov@lanl.gov Theoretical Division and Center for Nonlinear Studies Los Alamos National Laboratory Los Alamos, NM 87545

## Editor: Abstract

We introduce novel results for approximate inference on planar graphical models using the loop calculus framework. The loop calculus (Chertkov and Chernyak, 2006a) allows to express the exact partition function of a graphical model as a finite sum of terms that can be evaluated once the belief propagation (BP) solution is known. In general, full summation over all correction terms is intractable. We develop an algorithm for **the approach presented**
in Chertkov et al. (2008) which represents an efficient truncation scheme on planar graphs and a new representation of the series in terms of Pfaffians of matrices. We analyze the performance of the algorithm for the partition function approximation for models with binary variables and pairwise interactions on grids and other planar graphs. We study in detail both the loop series and the equivalent Pfaffian series and show that the first term of the Pfaffian series for the general, intractable planar model, can **provide very accurate** approximations. The algorithm outperforms previous truncation schemes of the loop series and is competitive with other state-of-the-art methods for approximate inference.

Keywords: belief propagation, loop calculus, approximate inference, partition **function,** planar graphs.

## 1. Introduction

Graphical models are popular tools widely used in many areas **which require modeling of** uncertainty. They provide an effective approach through a compact representation of the joint probability distribution. The two most common types of graphical models are Bayesian Networks (BN) and Markov Random Fields (MRFs).

The partition function of a graphical model, which plays the role of normalization constant in a MRF or probability of evidence (likelihood) in a BN **is a fundamental quantity**
which arises in many contexts such as hypothesis testing or parameter estimation. Exact computation of this quantity is only feasible when the graph **is not too complex, or equiv-** 
c Vicen¸c G´omez, Hilbert J. Kappen and Michael Chertkov.

arXiv:0901.0786v3 [cs.AI] 25 May 2009