But, if the normalization is needed for special applications, we can normalize at the end by dividing each component by the sum all components. 

If we work with intuitionistic logic/set (when the information is incomplete, i.e. the sum of the crisp components is less than 1, i.e. *sub-normalized*), or with paraconsistent logic/set (when the information overlaps and it is contradictory, i.e. the sum of crisp components is greater than 1, i.e. over-normalized), we need to define the neutrosophic measure of a proposition/set. If x(T,I,F) is a NL/NS, and T,I,F are crisp numbers in [0,1], then the **neutrosophic vector norm** 
of variable/set x is the sum of its components: 
 Nvector-norm(x) = T+I+F. 

Now, if we apply the Nn and Nc to two propositions/sets which maybe intuitionistic or paraconsistent or normalized (i.e. the sum of components less than 1, bigger than 1, or equal to 1), 
x and y, what should be the neutrosophic measure of the results Nn(x,y) and Nc(x,y) ? 

Herein again we have more possibilities: - either the product of neutrosophic measures of x and y: 
Nvector-norm(Nn(x,y)) = Nvector-norm(x)·Nvector-norm(y), 
- or their average: 
 Nvector-norm(Nn(x,y)) = (Nvector-norm(x) + Nvector-norm(y))/2, 
- or other function of the initial neutrosophic measures: 
Nvector-norm(Nn(x,y)) = f(Nvector-norm(x), Nvector-norm(y)), where f(.,.) is a function to be determined according to each application. 

 Similarly for Nvector-norm(Nc(x,y)). 

Depending on the adopted neutrosophic vector norm, after applying each neutrosophic operator the result is neutrosophically normalized. We'd like to mention that "**neutrosophically** normalizing" doesn't mean that the sum of the resulting crisp components should be 1 as in fuzzy logic/set or intuitionistic fuzzy logic/set, but the sum of the components should be as above: either equal to the product of neutrosophic vector norms of the initial propositions/sets, or equal to the neutrosophic average of the initial propositions/sets vector norms, etc. 

In conclusion, we neutrosophically normalize the resulting crisp components T`,I`,F` by multiplying each neutrosophic component T`,I`,F` with S/( T`+I`+F`), where S= Nvector-norm(Nn(x,y)) for a N-norm or S= Nvector-norm(Nc(x,y)) for a N-conorm - as defined above. 

c) If T, I, F are subsets of [0, 1] the problem of neutrosophic normalization is more difficult. 

i) If sup(T)+sup(I)+sup(F) < 1, we have an *intuitionistic proposition/set*. 

ii) If inf(T)+inf(I)+inf(F) > 1, we have a *paraconsistent proposition/set*. 

iii) If there exist the crisp numbers t ∈T, i ∈I, and f ∈F such that t+i+f =1, then we can say that we have a *plausible normalized proposition/set*. But in many such cases, besides the normalized particular case showed herein, we also have crisp numbers, say t1 ∈T, i1 ∈I, and f1∈F such that t1+i1+f1 < 1 (incomplete information) and t2 ∈T, i2 ∈I, and f2∈F such that t2+i2+f2 > 1 (paraconsistent information). 

## 4. **Examples Of Neutrosophic Operators Which Are N-Norms Or N-Pseudonorms Or,** Respectively N-Conorms Or N-Pseudoconorms.

We define a binary **neutrosophic conjunction (intersection)** operator, which is a particular case of a N-norm (neutrosophic norm, a generalization of the fuzzy T-norm): 