Landscapes [14], tuned by a natural number M, f(x) is rounded so that it can only take M different values. For all those problems, neutrality is tuned by one parameter only: neutrality increases according to p and decreases with q or M (see for example Figure 2).

Dynamics of a population on a neutral network are complex, even on flat landscapes as shown by Derrida [15]. The works [16]
[17] [18] [19], at the interplay of molecular evolution and optimization, study the convergence of a population on neutral networks. In the case of infinite population under mutation and selection, they show distribution on a NN is only determined by the topology of this network. That is to say, the population converges to the solutions in the NN with high neutral degree. Thus, the neutral degree distribution is an important feature of neutral landscapes.

In order to study more precisely neutrality, for instance link between neutrality and search difficulty, we need for "neutrality-driven design" where neutrality really guides the design process. In this paper we propose to generate a family of landscapes where it is possible to tune accurately the neutral degree of solutions.

## 2. Nd-Landscapes

In this section, we first present an algorithm to create a landscape with a given *neutral degree distribution*. Then we will refine the method to obtain more accurate landscapes and finally we will study time and space complexity of the algorithm.

## 2.1 An Algorithm To Design Small Nd-Landscape

We now introduce a simple model of neutral landscapes called ND-Landscapes where N refers to the number of bits of a solution and D to the neutral degree distribution. In this first step our aim is to provide an exhaustive definition of the landscape assigning one fitness value to each solution. We fix N to 16 bits and so the size of search space is 2 16. Building a ND-Landscape is done by splitting the search space into neutral networks. However the fitness value of each neutral network has no influence on the neutrality. This is why these fitness values are randomly chosen.

Let D be an array of size N+1 representing a neutral degree distribution. N and D are given as inputs and the algorithm (see algorithm 1) returns a fitness function f from {0, 1}
N to IR such that the neutral degree distribution of the fitness landscape is similar to D. For more simplicity, we chose to give a different fitness value to each neutral network. We define RouletteWheel(D) as a random variable whose density is given by distribution D. It is directly inspired from the genetic algorithm selection operator. For example:
let ∆ be the following distribution :
∆[0]=0 ∆[1]=0.25 ∆[2]=0.5 ∆[3]=0.25. RouletteWheel(∆)
will return value 1 in 25 % of the time, 2 in 50 % of the time and 3 in 25 % of the time. Figure 1 shows the neutral networks of an ideal ND-Landscape (size=2 5) for the distribution ∆.

## 2.2 A Metaheuristic To Improve The Nd Design

Using algorithm 1, exhaustive fitness allocation does not create a landscape with a neutral degree distribution close enough to the input distribution. The reason is the fitness function is completely defined before the neutral degree of every solution has been considered. Hence, we use a simulated annealing metaheuristic to improve the landscape created by algorithm 1. Here, simulated annealing is not used to find a good solution of a ND-Landscape but to adjust the landscape by modifying the fitness of some solutions such as neutral distribution of a ND-Landscape be closer to the input distribution. The local operator is the changement of fitness value of one solution of the landscape, which can alter at most N+1

![0_image_0.png](0_image_0.png)

Figure 1: Example of a tiny ND-Landscape. Each node represents a solution and two nodes are connected if they have the same fitness value and are Hamming neighbours. In this example there are five neutral networks.

## Algorithm 1 Generation Of Nd-Landscapes

∀s ∈ S, f[s] ← unaffected randomly choose one solution s0.

CandidatesList ← S sorted by distance from s0.

while not empty(*CandidatesList*) do s ← head(*CandidatesList*)
for d = 0 to N do if s can't have d neutral neighbours then D'[d] ← 0 else D'[d] ← D[d]
end for n ← RouletteWheel(D'[d])
Give a value to some unaffected neighbours so that s has exactly n neutral neighbours and so that the neutral degrees of already chosen solutions (6∈ *CandidatesList*) are unchanged.

D[n] ← D[n] - 1 2N
CandidatesList ← next(*CandidatesList*)
end while