found in the literature deals with neutrality, either as an add-on feature or as an incidental property. Theoretical studies in molecular evolution, as well as in optimization, show that the distribution of neutral degree is a key factor in the evolution of population on a neutral network. Hence to understand and study the influence of neutrality on evolutionary search process it may be helpful to design landscapes with a given neutral distribution. We propose three steps to design such landscapes: first using an algorithm we construct a landscape whose distribution roughly fits the target one, then we use a simulated annealing heuristic to bring closer the two distributions, and finally we affect fitness values to each neutral network. The last step can be used to tune the landscape difficulty according to other criteria than neutrality. So we can study interaction between neutrality and another source of hardness. In this paper we use trap functions to affect fitness values, this allows us to study the interplay between deceptiveness and neutrality; in particular, experimental results show that neutrality smoothes the correlation between fitness and distance. For some problems, introducing neutrality could be benefic as shown in [25] by increasing the evolvability. On the other hand, neutrality could destroy useful information such as correlation as it is shown in our experiments.

As these landscapes need an exhaustive enumeration of the search space we propose to concatenate small ND-Landscapes to scale up over 16 bits. Then, using the convolution product of distribution, we are able to design large landscapes with known neutral distribution.

Future work along these lines includes studying the influence of various distributions and different ways to affect fitness value on the dynamics of a population on a neutral network. With ND-trap functions we have focused on the interplay between deceptiveness and neutrality. By replacing trap functions by NK functions[11], we might be able to highlight correlation between epistasis and neutrality.

## 5. References

[1] S. Wright. The roles of mutation, inbreeding, crossbreeding, and selection in evolution. In Proceedings of the Sixth International Congress of Genetics 1, pages 356–366, 1932.

[2] M. Kimura. *The Neutral Theory of Molecular Evolution*.

Cambridge University Press, Cambridge, UK, 1983.

[3] N. Eldredge and S. J. Gould. Punctuated equilibria: An alternative to phyletic gradualism. In T. J. M. Schopf, editor, Models in Paleobiology, pages 82–115. Freeman Cooper, San Francisco, 1972.

[4] Inman Harvey and Adrian Thompson. Through the labyrinth evolution finds a way: A silicon ridge. In *ICES*, pages 406–422, 1996.

[5] Vesselin K. Vassilev and Julian F. Miller. The advantages of landscape neutrality in digital circuit evolution. In *ICES*,
pages 252–263, 2000.

[6] Tina Yu and Julian F. Miller. Finding needles in haystacks is not hard with neutrality. In *EuroGP*, pages 13–25, 2002.

[7] T.M.C. Smith, A. Philippides, P. Husbands, and M. O'Shea.

Neutrality and ruggedness in robot landscapes. In Congress on Evolutionary Computation: CEC2002, pages 1348–1353. IEEE Press, 2002.

[8] Chad W. Seys and Randall D. Beer. Evolving walking: The anatomy of an evolutionary search. In S. Schaal, A. Ijspeert, A. Billard, S. Vijayakumar, J. Hallam, and J.-A. Meyer, editors, Animals to Animats, Proceedings of the Eight international Conference on Simulation of Adaptive Behavior, pages 357–363. The MIT Press, 2004.

[9] P. F. Stadler. Fitness landscapes. In M. L¨assig and Valleriani, editors, *Biological Evolution and Statistical Physics*, volume 585 of *Lecture Notes Physics*, pages 187–207, Heidelberg, 2002. Springer-Verlag.

[10] M. Mitchell, S. Forrest, and J. H. Holland. The royal road for genetic algorithms: Fitness landscape and GA performance. In F.J Varela and P. Bourgine, editors, *Proceedings of the* First European Conference on Artificial Life, pages 245–254, Cambridge, MA, 1992. MIT Press/Bradford Books.

[11] S. A. Kauffman. *The Origins of Order*. Oxford University Press, New York, 1993.

[12] L. Barnett. Ruggedness and neutrality - the NKp family of fitness landscapes. In C. Adami, R. K. Belew, H. Kitano, and C. Taylor, editors, ALIFE VI, Proceedings of the Sixth International Conference on Artificial Life, pages 18–27.

ALIFE, The MIT Press, 1998.

[13] M. Newman and R. Engelhardt. Effect of neutral selection on the evolution of molecular species. In *Proc. R. Soc. London* B., volume 256, pages 1333–1338, 1998.

[14] J. Lobo, J. H. Miller, and W. Fontana. Neutrality in technological landscapes. *Santa Fe Working Paper*, 2004.

[15] B. Derrida and L. Peliti. Evolution in a flat fitness landscape.

Bull. Math. Biol., 53:355–382, 1991.

[16] E. Bornberg-Bauer and H.S. Chan. Modeling evolutionary landscapes: Mutational stability, topology and superfunnels in sequence space. *Proc. Natl. Acad. Sci. USA, track 2*, 96(19):10689–10694, 1999.

[17] Erik Van Nimwegen, James P. Crutchfield, and Martijn Huynen. Neutral evolution of mutational robustness. In *Proc.* Nat. Acad. Sci. USA 96, pages 9716–9720, 1999.

[18] Erik Van Nimwegen and James P. Crutchfield. Optimizing epochal evolutionary search: Population-size dependent theory. *Mach. Learn.*, 45(1):77–114, 2001.

[19] C. O. Wilke. Adaptative evolution on neutral networks. *Bull.*
Math. Biol, 63:715–730, 2001.

[20] K. Deb and D. E. Goldberg. Analyzing deception in trap functions. In D. WhitIey, editor, Foundations of Genetic Algorithms 2, pages 93–108. Morgan Kaufmann, 1993.

[21] T. Jones. Evolutionary Algorithms, Fitness Landscapes and Search. PhD thesis, University of New Mexico, Albuquerque, 1995.

[22] L. Altenberg. Fitness distance correlation: an instructive counterexample. In T. Back, editor, *Seventh International* Conference on Genetic Algorithms, pages 57–64. Morgan Kaufmann, 1997.

[23] R.J. Quick, V.J. Rayward-Smith, and G.D. Smith. Fitness distance correlation and ridge functions. In A. E. Eiben et al.,
editor, *Fifth Conference on Parallel Problems Solving from* Nature (PPSN'98), volume 1498 of *Lecture Notes in* Computer Science, pages 77–86. Springer-Verlag, Heidelberg, 1998.

[24] Manuel Clergue and Philippe Collard. Ga-hard functions built by combination of trap functions. In David B. Fogel, Mohamed A. El-Sharkawi, Xin Yao, Garry Greenwood, Hitoshi Iba, Paul Marrow, and Mark Shackleton, editors, Proceedings of the 2002 Congress on Evolutionary Computation CEC2002, pages 249–254. IEEE Press, 2002.

[25] Marc Ebner, Mark Shackleton, and Rob Shipman. How neutral networks influence evolvability. *Complex Systems*,
7(2):19–33, 2001.