# A Knowledge Discovery Framework For Learning Task Models From User Interactions In Intelligent Tutoring Systems

Philippe Fournier-Viger1, Roger Nkambou1, and Engelbert Mephu Nguifo2 1 University of Quebec in Montreal, Montreal (QC), Canada 2 Université Lille-Nord de France, Artois, F-62307 Lens, CRIL, F-62307 Lens CNRS UMR 8188, F-62307 Lens, France fournier_viger.philippe@courrier.uqam.ca, nkambou.roger@uqam.ca, mephu@cril.univ-artois.fr Abstract. Domain experts should provide relevant domain knowledge to an Intelligent Tutoring System (ITS) so that it can guide a learner during problemsolving learning activities. However, for many ill-defined domains, the domain knowledge is hard to define explicitly. In previous works, we showed how sequential pattern mining can be used to extract a partial problem space from logged user interactions, and how it can support tutoring services during problem-solving exercises. This article describes an extension of this approach to extract a problem space that is richer and more adapted for supporting tutoring services. We combined sequential pattern mining with (1) dimensional pattern mining (2) time intervals, (3) the automatic clustering of valued actions and (4) closed sequences mining. Some tutoring services have been implemented and an experiment has been conducted in a tutoring system 

## 1 Introduction

Domain experts should provide relevant domain knowledge to an Intelligent Tutoring System (ITS) so that it can guide a learner during problem-solving activities. One common way of acquiring such knowledge is to use the method of cognitive task analysis that aims at producing effective problem spaces or task models by observing expert and novice users for capturing different ways of solving problems. However, cognitive task analysis is a very time-consuming process [1] and it is not always possible to define a satisfying complete or partial task model, in particular when a problem is ill-structured. According to Simon [2], an ill-structured problem is one that is complex, with indefinite starting points, multiple and arguable solutions, or unclear strategies for finding solutions. Domains that include such problems and in which, tutoring targets the development of problem-solving skills are said to be ill-defined (within the meaning of Ashley et al. [3]). An alternative to cognitive task analysis is constraint-based modeling (CBM) [4], which consist of specifying sets of constraints on what is a correct behavior, instead of providing a complete task description. 

Though this approach was shown to be effective for some ill-defined domains, a domain expert has to design and select the constraints carefully. 

A. Gelbukh and E.F. Morales (Eds.): MICAI 2008, LNAI 5317, pp. 765–778, 2008. 

© Springer-Verlag Berlin Heidelberg 2008 