support value is less than 0.50, then S2 is deemed frequent. To mine sequential patterns several algorithms have been proposed [11, 12, 13]. In our first experiment in RomanTutor, we chose PrefixSpan [12] as it is a promising approach for mining large sequence databases having numerous patterns and/or long patterns, and also because it can be extended to mine sequential patterns with user-specified constraints. Figure 2.b shows some sequential patterns extracted by PrefixSpan from the data in figure 2.a using a minimum support of 25%. In RomanTutor, one mined pattern is for example, to select the camera 6, which gives a close view of the arm in its initial position, slightly decrease the yaw of camera 6, select the elbow joint and decrease a little bit its rotation value. Although, the set of patterns extracted for RomanTutor constitutes a useful problem space that capture different ways of solving problems, we present next the limitations of SPM encountered in our first experiment, and extensions to PrefixSpan to address these issues. 

| ID                                                                                                                                       | Sequences of actions   | ID                                                                | Seq. patterns                   | Support   |
|------------------------------------------------------------------------------------------------------------------------------------------|------------------------|-------------------------------------------------------------------|---------------------------------|-----------|
| 1 2 25 46 48 {9 10 11 31}  1 25 46 54 {10 11 25} 48  1 2 3 {9 10 11 31} 48  2 3 25 46 11 {14 15 48} 74  4 1 25 27 46 48  1 3 44 45 46 48 | S1  S2  S3  S4  S5  …  | 1 46 48  1 25 46 48  1 25 46 {10 11}  1 {9 10 31}  1 {9 11 31}  … | 66 %  50 %  33 %  33 %  33 %  … |           |
| Æ                                                                                                                                        |                        |                                                                   |                                 |           |

Fig. 2. (a) A Data Set of 6 Plans (b) Example of Sequential Patterns Extracted 

## 4 Extending Sequential Pattern Mining With Time Intervals

A first limitation that we encountered is that extracted patterns often contain "gaps" with respect to their containing sequences. For instance, in the example of figure 2, action "2" of plan 1 has not been kept in S1. A gap of a few actions is ok in a tutoring context because it eliminates non-frequent learners' actions. But when a sequence contain many or large gap(s), it becomes difficult to use this sequence to track a learner's actions and to suggest a next relevant step. Thus, there should be a way of limiting the size of the gaps in mined sequences. Another concern is that some patterns are too short to be useful in a tutoring context (for example, sequences of size 1). In fact, there should be a way of specifying a minimum sequential pattern size. 

An extension of SPM that overcomes these limitations is to mine patterns from a database with time information. A time-extended database is defined as a set of timeextended sequences s = <(t1,X1), (t2,X2),…, (tn,Xn)>, where each actionset Xx is annotated with a timestamp tx. Each timestamp represents the time elapsed since the first actionset of the sequence. Actions within a same actionset are considered simultaneous. 

For example, one time-extended sequence could be <(0, a), (1, b c), (2, d)>, where action d was done one time unit after b and c, and two time units after a. The time interval between two actionsets (tx,Xx) and (ty,Xy) is calculated as |tx - ty|. In this work, we suppose a time interval of one time unit between any adjacent actionsets, so that |tx - ty| become a measure of the number of actionsets between (tx, Xx) and (ty, Xy). The problem of Generalized Sequential Pattern Mining with Time Intervals (GSPM) [14] is to extract all time-extended sequences s from a time-extended database, such that 