to 60, 60 to 100, and more than 140 degrees. The disadvantage with this categorization is that it is fixed. In order to have dynamic categories of actions, we extended the Hirate-Yamana algorithm to perform an automatic clustering of valued actions. 

We propose to define a valued sequence database as a time-extended sequence database, where sequences can contain valued actions. A valued action *a{value}*, is defined as an action a that has a value *value*. In this work, we consider that a value is an integer. For example, the sequence <(0,a{2}), (1,b), (2,bc{4})> contains the valued action a, and b with values 2 and 4, respectively. The left part of figure 4 shows an example of a sequence database containing valued actions. 

| ID                                                                                                                                          | Time-extended sequences                                               | Mined valued seq. patterns      | Supp.   |
|---------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------|---------------------------------|---------|
| <(0,a{2}), (1,bc{4})>  <(0,a{2}), (1,c{5}))>  <(0,a{5}), (1,c{6}))>  < (0,f), (1,a{6}))>  <(0, f b{3}), (1,e) , (2,f))>  <(0,b{2}), (1,d))> | <(0,a{2})>  <(0,a{5})>  <(0,a{2}), (1, c{5})>  <(0,c{5})>  <(0,f)>  … | 33 %  33 %  33 %  50 %  33 %  … |         |
| Æ                                                                                                                                           |                                                                       |                                 |         |

Fig. 4. Applying Hirate-Yamana with Automatic Clustering of Valued Actions To mine patterns from a valued database, we added a special treatment for valued actions. We modified the action/pair counting of the Hirate-Yamana algorithm to note the values of the action being counted, and their sequence ids. We modified the database projection operation ISDB|(t,i) so that it can be called with a valued action i and a set of values V={v1, v2…, vn}. If the support of i in ISDB is higher or equals to 2 * 
minsup, the database projection operation calls the K-Means algorithm [15] to find clusters. The K-Means algorithm takes as parameter K, a number of clusters to be created, and the set of values V to be clustered. K-Means first creates K random clusters. Then it iteratively assigns each value from V to the cluster with the nearest median value until all clusters remain the same for two successive iterations. In the database projection operation, K-Means is executed several times starting with K=2, and incrementing K until the number of frequent clusters found (with size >= *minsup*) does not increase. This larger set of frequent clusters is kept. Then, the sequences of ISDB|(t,i) are separated into one or more databases according to these clusters. Afterward, *algoProjection* is called for each of these databases with size equal or greater than *minsup*. 

Moreover, if ISDB|(t,i) is called from *algoHirate* and n clusters are found, instead of just adding <(o,{i})> to the set R of sequences found, <(0, i{vx1})>, <(0, i{vx2})> … <(0, i{vxn})> are added, where vx1, vx2, .. vxn are the median value of each cluster. 

Similarly, we have adapted *algoProjection* so that sequences are grown by executing Concatenate with (t, i{vx1}), (t, i{vx2}) … (t, i{vxn}, instead of only <(t,{i})>. 

The right part of figure 4 shows some sequences obtained from the execution of the modified algorithm with a *minsup* of 32 % (2 sequences) on the valued sequence database depicted in the left part of figure 4. From this example, we can see that the action "a" is frequent (with a support of 4) and that two clusters were dynamically created from the set of values {2, 2, 5, 6} associated to "a". The first cluster contained the values 2 and 2 with a median value of 2 and the second one contained 5 and 6 