We here explain the crucial role episodic memory (or pseudohippocampus) plays in our model's episodic learning 

![0_image_0.png](0_image_0.png)

mechanisms associated with emotion. These mechanisms consist of the encoding of any given information coupled with its assigned emotional valence, and the encoding of the agent's actions. 

The episodic memory or "pseudo-hippocampus" is composed of two main mechanisms called "memory consolidation" and "episodic learning" [5]. These intervene in the memorization and the retrieval phases of the events in CTS's memory architecture respectively. The memorization phase of the CTS 
architecture includes emotional valences ascribed to ongoing events by the Emotional Mechanism [6]. Emotional valences are here taken to be CTS's memorization of valenced reactions to given emotional situations (stimuli) as described in the OCC 
model [7]. All events sequences are distributed and then stored in different memories in CTS. The memorization phase also includes the process of memory consolidation [5]. This process constantly extracts temporal regularities from all past episodes to form a procedural memory. This process is very important because as a cognitive agent, CTS receives a huge amount of data which is temporally related to its environment. Moreover, much communication takes place between the different parts of the system. This produces a large amount of data during each cognitive cycle which accumulates. In order to be used in decision making, it needs to be consolidated into a smaller form. 

In our architecture, this is achieved through sequential pattern mining [8], for it is an efficient knowledge discovery technique that is widely used in computer science to find frequent temporal patterns among sequences of symbols to face huge amount of data, a common situation with CTS. This provides a functionally plausible memory consolidation model. These sequential patterns are useful in the retrieval (remembering) phase to adapt CTS's behavior to past experiences. In the retrieval phase, a retrieval cue is introduced to all sequential patterns previously created by the system, making them active, each according to its likeness to the cue. The information sequence activated in parallel thus reinforces the cue's content. 

Of course, this generic architecture of emotion and learning could be implemented in any cognitive or real-time agent. In our specific case it helps to sustain better tutorial interventions. In the present paper, we will begin by a brief review of the existing work concerning episodic learning in cognitive agents. We will then propose our new architecture combining elements of the Emotional Mechanism (EM) and episodic memory. Finally, we will present results from our experiments with this cognitive agent. 

## 2. **A Comparison Between** Episodic Memory Implemented In Different Cognitive Agents Various Models Of Episodic Memory Have Been Proposed And

implemented, for example LIDA [9]. They have attempted to implement episodic learning [9] but none have succeeded. To begin, it must be noted that Sidney et al. have not performed any empirical experiments about episodic learning on their proposed agent LIDA. Moreover, in their agent, the Episodic and Semantic Memories are separated and have totally different structures - this impedes a joint memory consolidation. In humans however, episodic and semantic memories activate overlapping brain regions [5]. In this way, episodic and semantic memories consolidate each other during the learning of a new event and during the remembering phase. These are ignored in LIDA's architecture. It is also unclear how LIDA encodes time for a given episode in its system. Lastly, an event may be associated to a procedure. In their paper they do not address how this is possible. 

In the well-known ACT-R model, there is no explicit episodic memory. Instead, episodic events are encoded in the declarative memory as chunks, just like declarative information. During the recall, beside the activation provided by the context, a base level 