maximum number of 2 time unit between any two adjacent events. 

Table 1 shows an example of a database containing 6 short sequences. The first event of sequence S1 shows that during cognitive cycle 0, coalition c1 was broadcasted and that an emotional valence of 0.8 for emotion e1 (high threat) was associated with the broadcast. The second event of S1 indicates that at cognitive cycle 1, coalition c2 was broadcasted with emotional valence 0.3 for emotion e2 (medium fear) and that behavior b1 was executed. Table 2 shows some sequences obtained from the application of the algorithm on the database of Table 1 with a minsup of 32 % (2 sequences) and no time constraints. The first frequent pattern is <0, c1 e1 {0.7})>, which was found in sequences S1, S2, S4 and S6. Because the events containing e1 in these sequences have numeric values 0.8, 0.8, 0.6 and 0.6, the algorithm calculated the average when extracting that pattern, which resulted in the first event having e1 with value {0.7}. Because this pattern has a support of 66 % (4 out of 6 sequences), which is higher than minsup, it is deemed frequent. 

Table 1. A Data Set of 6 Sequences ID Events sequences S1 <(0, c1 e1{0.8}), (1, c2 e2{0.3} b1)> 
S2 <(0, c1 e1{0.8}), (1, c3), (2, c4 b4), (3, c5 b3)> S3 <(0, c2 e2{0.3}), (1, c3), (2, c4), (3, c5 b3)> 
S4 <(0, c3), (1, c1 e1{0.6} b4),(2, c3)> 
S5 <(0, c4 b4), (1, c5), (2, c6)> 
S6 <(1, c1 e1{0.6} b4), (2, c4 b4), (3, c5)> 
Finally, among mined sequences, there can be many redundant sequences. To facilitate consolidation of memory and decrease redundancy, we choose to mine only frequent closed sequences. "Closed sequences" are the sequences not contained in any other sequence with the same support. A closed pattern induces an equivalence class of patterns sharing the same closure, i.e. all the patterns belonging to the equivalence class are verified by exactly the same set of sequences (they have the same support). 

The set of closed frequent sequences is a compact representation of the set of frequent sequences, because it allows the reconstitution of the set of all frequent sequences and their support [14]. In this work, we choose to mine only closed sequences as it results in fewer sequences, and prevents information loss. 

## 4.3 **The Episodic Learning Process**

The episodic learning mechanism constantly adapts to the agent behavior by intervening in the coalitions selection phase of CTS, 
as follows. At each cognitive cycle, before choosing the candidate coalition to be broadcasted, all the frequent events sequences are scanned for finding those that matches with the coalitions broadcasted at previous cognitive cycles. The last n broadcasted coalitions are represented as a sequence Sc=<(0,c1), 
(1,c2)... (n,cn**)>. The "***episodic learning***" mechanism checks all** 
frequent sequences to find each sequence Sa=<(t1,a1), (t2, a2**), ...** 
(tn,an**)> such that for a number k > 1, the sequence defined by** 
the last k broadcasts of Sc <(tn-k+1, cn-k+1), (tn-k+2,cn-k+2**) ... (t**n,cn)> 
is included in Sa and there is an event following that sequence occurrence that contains a coalition that is candidate for being broadcast during the current cognitive cycle. The "episodic learning mechanism" then computes, for each sequence, the sequence strength which is defined as the support of the sequence multiplied by the sum of emotional valences associated to each broadcast occurrence in the sequence. The episodic learning mechanism then adds, for each coalition that is candidate to be broadcast, the strength of the strongest sequence containing it and the strength of the weakest sequence containing it. The "episodic learning mechanism" selects the coalition with the highest sum. This coalition will be broadcast in favor of other coalitions waiting to be broadcasted. 

| Table 2. Example of Events Sequences Extracted  Mined sequences Support   |      |
|---------------------------------------------------------------------------|------|
| <(0, c1 e1{0.7})>                                                         | 66 % |
| <(0, c3), (2, c5 b3)>                                                     | 33 % |
| <(0, c4 b4), (1, c5)>                                                     | 50 % |
| <(1, c3), (2, c4), (3, c5 b3)>                                            | 33 % |
| …                                                                         | …    |

## 5. **Experimentation**

We performed various preliminary experiments to validate CTS's new episodic learning. **One experiment conducted with** 
user 3 is here detailed. User 3 tended to make frequent mistakes when he was asked to guess the arm distance from a specific part of the ISS and its name (Figure 2.A). Obviously, this situation caused collision risks between the arm and ISS and was thus a very dangerous situation. This situation was implemented in the CTS's Behavior Network [14] (Figure3). In this situation, the CTS Episodic Learning mechanism (Figure 2.B) **had to make a decision** 
between giving a direct solution "*You should move joint SP*" 
(Figure 3. Scenario 1) or a brief hint such as "*This movement is* dangerous. Do you know why**?" (Figure 3. Scenario 2).** 
Interacting with different users, CTS learned about their profiles. 

For user 3, the experiments showed that it is better to first give a hint and then ask the user to think about the situation and lastly giving him the answer. At the end of each scenario CTS asks an evaluation question to verify the effectiveness of its interventions (Figure 3. Evaluation). As we mentioned previously, CTS Behavior Network (Figure 3) possesses two paths to solve this problem. In the case of User 3, CTS chose the second option and presented a hint followed by an answer 
(Figure2.C). User 3 did not remember the answer, so a help (a hint and not a solution) was proposed to him to push him to think more about the situation. He still did not remember, so CTS finally signaled to User 3 that this situation would end with a collision with the ISS. 