
## 6. **Behavior Of The Data Mining Algorithm In** Mining Patterns From Recorded Sequences

Here, we sought to observe how the data mining algorithm behaved when the number of recorded sequences increased. The experiment was done on a 3.6 GHz Pentium 4 desktop computer running Windows XP, and consisted of performing 160 CTS executions for a situation similar to the one described above. In this type of situation, CTS conducts a dialogue with the student that includes from two to nine messages or questions (an average of six) depending on what the learner answers and the choices CTS makes (situation similar to that of choosing between scenarios 1 and 2). 

During each trial, we randomly answered the questions CTS 
asked. Each recorded sequence contained approximately 26 broadcasts. Figure 4 presents the results of the experiment. The first graph shows the time required for mining frequent patterns after each CTS execution. From this graph, we see that the time for mining frequent patterns was generally short (not more than 6 seconds) and that the algorithm's behavior tended to increase linearly with the number of recorded sequences. For our purposes, this performance is promising. However, it could still be improved for we have not yet fully optimized the algorithm to perform incremental mining of sequential patterns as some other sequential patterns mining algorithms do [20]. We are currently working on making it possible, for it would improve performance, as it would no longer be necessary to recompute the set of patterns for each new added sequence from scratch.

The second graph shows the average size of patterns found during each execution. It ranges from 9 to 16 broadcasts. The third graph depicts the number of patterns found. It remained low and stabilized at around 8.5 patterns during the last executions. The reason why the number of patterns is small is that we mined only closed patterns (c.f. section 4.2). If we had not mined only closed patterns, the number of patterns would have been much higher as all the subsequences of all patterns would have been included in the results. Mining closed patterns is also much faster as during the search for patterns large parts of the search space that are guaranteed not to lead to close patterns are pruned. For example, for mining non closed patterns from the first four sequences only, it tooks more than 1 hour (we stopped the algorithm after 1 hour), while mining closed patterns took only 0.558 second. The reason for this is that the four sequences share more than fifteen common broadcasts. 

Therefore, if the pruning of the search space is not done, the algorithm has to consider all combinations of these broadcasts, which is computationally very expensive. This demonstrates that it is beneficial to mine closed patterns. Finally, the fourth graph presents the average time for executing the Episodic learning algorithm at each execution. This time was always less than 5 milliseconds. Thus, the costliest operation of the learning mechanism is definitely the extraction of patterns. 

![0_image_0.png](0_image_0.png)

## 7. **Conclusion**

As far as we know, no cognitive agent presently uses data mining algorithms. Nonetheless, they have proven very useful for extracting significant information from the huge amount data that they have to handle. The interaction between an agent and its dynamic environment also generates large amounts of data. 

The episodic learning algorithm used in this work is inspired from a memory consolidation theory which is biologically plausible. The collaboration between the Emotional mechanism and this Episodic Learning helps to choose the corresponding behaviors that are most likely to bring the agent to a selfsatisfactory emotional state. CTS learns, during real time interactions with astronauts , how to associate an event and its corresponding emotional valences witha partial/complete sequences of behaviors chosen by their Behavior Network for execution. In the future, we will perform further experiments to measure empirically how CTS influence the learning of students. We will investigate different ways of improving the performance of our sequential pattern mining algorithm, including the possibility of modifying it to perform an incremental mining of sequential patterns. We also plan to compare the Episodc Learning mechanism with others agent learning mechanisms. Lastly, we are interested in exploring different forms of learning in multi-agent systems by applying data mining techniques, mining other types of temporal patterns such as trends for improving agents' behavior, and mining patterns from group behaviors. 

## 8. **Acknowledgments**

Our special thanks to our colleague Sioui Maldonado Bouchard for her collaboration in this paper, and Daniel Dubois, Sebastien Dubourdieu and Mohamed Gaha for their contribution to the development of CTS. The authors also thank the Fonds Québécois de la Recherche sur la Nature et les Technologies and 