Figure 1: Multi-Agent Framework

![0_image_0.png](0_image_0.png)

El Diario de Hoy6**, and** *Diario Co Latino*7**. Diario Co Latino**
is considered left-leaning meanwhile the other two newspapers range from right-leaning to ultra-right [4]. After collecting the headlines, reader agents parse the news articles' HTML source, extracting their title and corresponding text. Then, they input this data to the analyst agents **responsible for text analysis.**

## 2.2 Text Analysis: Key Phrases, Topics And Clustering

Analyst agents extract automatically organize small collections of news articles into thematic categorie using Carrot2**[11], a**
search results clustering engine. The agents also extract the latent topics from the texts using the state-of-the-art latent Dirichlet allocation (LDA) algorithm implemented in MALLET [6]. Currently, one specialized agent per task is used, but more can be instantiated to achieve a better degree of parallelization. The results of the text analysis form the basis for the blog entries **to be**
posted.

## 2.3 Intelligent Agent Blogger

The Blogger Agent **is responsible for posting the summaries of**
the news articles, where a single entry in the blog corresponds to the clusters found. That is, each post contains the summaries of the news articles that are related, with their corresponding link to the sources. The latent topics identified are used as tags for the blog post, in order to create a more coherent classification and to facilitate search. Here Blogger Data API [1] was used for blog entry creation.

## 3. Discussion

The multi-agent framework, which in the end interface with the user through a blog, is successful in aiding the discovery of **interrelated news stories across media outlets, facilitating the ideal**
scenario where a user is able to access all sources of information to get an unbiased perspective. We opted to use a blog because its format emphasizes a participatory journalism**, which in this**
case Intelligent Agents play an active role in the process of **collecting, analyzing and disseminating information. Furthermore,** a blog facilitates user participation and discussion through comments, and it also helps to keep track of news stories development over time.

Not surprisingly, the textual analysis tools are not optimized for the Spanish language, and some special configuration, and small modifications were required to achieve the desirable performance.

While several systems aim to provide a global aggregation of news [3], and analysis of worldwide news stories development [2], we focus on the niche of local news of El Salvador, exploiting available tools of text analysis to cope with the bias exhibited by the local mass media in their coverage. We consider our focus not 6**http://www.ElDiarioDeHoy.com/**
7
**http://www.DiarioCoLatino.com/**
a limitation, but rather an answer to *The Long Tail* **phenomenon**
exhibited by those services.

Adapting the system to a different country or sources of information would not involved a great effort, basically it would require the implementation of new reader agents.

## 4. Conclusions And Future Work

We presented ongoing work towards alleviating media bias: an intelligent agent based system for the analysis of news articles.

We focus on a set of media outlets from El Salvador, approximating the conditions of an ideal scenario where a reader with access to all news sources could get an unbiased perspective. We present a coherent organization of related news article within a blog, which is automatically updated on a daily basis; easing the task for the users of finding related information across multiple sources through a single location, keeping track of the evolution of opinions and news development over time, e.g., using an easily accessible blog archive, and allowing them to participate through comments and discussions.

As future work, we plan to integrate sentiment analysis techniques to help us determine the polarity of the news articles **toward predefined entities, e.g., political parties, political figures**
or organizations. Besides that, we plan to provide Personalized Recommendations of blog posts according to the reader's particular interest. Furthermore, we plan to use our framework to also monitor media partisan-bias during the coming elections in El Salvador, which will provide us with a good opportunity to carry out a deeper user study.

Although our preliminary empirical evaluation is promising and support the validity of our approach, which is also sustained by a solid economic model of market for news [7], we believe that our contribution is an initial step on how the current Web 2.0 paradigm and readily available AI technology impact processes of democratisation, e.g., providing the individuals with better tools for their rational decisions, while holding media outlets accountable for their work. Additional research in this field is still to be explored.

## 5. Acknowledgments

This work has been partially supported by the Programme Alβ**an, the European Union Programme of High Level Scholarships for Latin America, scholarship no(E07D400591SV).**

6. REFERENCES
[1] Blogger Data API. http://code.google.com/apis/blogger/. [2] European Media Monitor. http://emm.jrc.it/. [3] Google News. http://news.google.com/.

[4] L. M. Ladutke. *Freedom of Expression in El Salvador: The* Struggle for Human Rights and Democracy**. McFarland &**
Co., 2004.

[5] M. C. Stelling, M. J. Villa, V. E. Ducrot, R. F. Carvallo, and F. L´opez. Monitoreo de los principales medios de comunicaci´on social de alcance nacional y regional: El Salvador: elecciones alcaldes y diputados**. 2006.**
[6] A. K. McCallum. Mallet: A machine learning for language toolkit. http://mallet.cs.umass.edu, 2002.

[7] S. Mullainathan and A. Shleifer. The Market for News.

American Economic Review**, 95(4):1031–1053, 2005.**
[8] Salvadoran Foundation for Economic and Social Development (FUSADES). EL SALVADOR'S Democratic Institutions: Assessments and Recommendations**. 2006.**
[9] M. Steyvers and T. Griffiths. Probabilistic Topic Models.

Latent Semantic Analysis: A Road to Meaning. Laurence Erlbaum**, 2005.**
[10] The American Society of Newspaper Editors (ASNE).

Examining Our Credibility: Perspectives of the Public and the Press, Examining Credibility, Explaining Ourselves.

1999.

[11] D. Weiss and S. Osinski. Carrot2, an open source search results clustering engine - http://project.carrot2.org/.