Algorithm 4**: selection** AM
Input: A graph G representing a collection C **of concepts and an**
anti-monotonic selection predicate p Output**: A graph** G
′**representing the collection** σp(C)
G
′ = empty **graph**
insert vertex(⊤, G
′)
insert vertex(⊥, G
′)
E = ∅ // E is a global variable explore(⊥)
return G
′
In the general case, to compute the selection of a collection **of concepts with respect**
to a predicate p, we must traverse the graph representing the collection and **test** p on all concepts.

However, when p **is monotonic or anti-monotonic, it is not necessary to traverse the**
whole graph. A predicate p is anti-monotonic iff (¬p(X, Y ) ∧ ((**X, Y** )  (X
′, Y ′))) ⇒
¬p(X′, Y ′) and monotonic iff (¬p(X, Y ) ∧ ((X′, Y ′)  (X, Y ))) ⇒ ¬p(X′, Y ′). Therefore, if p is anti-monotonic, the graph can be explored bottom up (from ⊥ to ⊤**) and if**
a concept X that does not satisfy p **is found, it is not necessary to explore its successors**
(see Alg. 4). Dually, for a monotonic constraint, the graph is explored top down.

Procedure explore(**vertex V** )
E = E ∪ {V } // E is a global variable forall X ∈ predecessor(V ) and X **marked** do insert marked vertex(X, G
′)
insert edge(X → V , G
′)
link to **top = true**
forall X ∈ **successor**(V ) do if p(X) and X not marked **then**
link to **top = false**
if X 6∈ E **then**
insert vertex(X, G
′)
explore(X)
insert edge(V → X, G
′)
else insert marked vertex(X,G
′)
insert edge(V → X, G
′)
if link to top **then**
insert edge(V → ⊤)

## 6 Conclusion

In this article, we made an original study on how to represent **and query collections of** concepts. We proposed to store these collections using a graph representation and we defined two kinds of operators: selection and projection.

We want to extend this work in several directions. First, it would be interesting to study the scalability of our representation on real datasets and make comparison with,