Example 1. In our example of Fig. 1, (ABD, **123) (we use this notation for** ({A, B, D}, {1, 2, 3})) and (E, 135) are 1-rectangles. (ABC, **12) is a bi-set but** is not a 1-rectangle since C **is not in relation with 1.**
The inclusion ⊆ on bi-sets is defined by: (X1, Y1) ⊆ (X2, Y2) iff X1 ⊆ X2 and Y1 ⊆ Y2. A formal concept **is then a maximal 1-rectangle for the order defined**
on bi-sets by the inclusion. The collection of all formal concepts in a database Db is Concepts(Db**) (see Fig. 1).**
We then define an order on the concepts as follow: (X, Y )  (X′, Y ′**) iff**
X ⊆ X′ and Y
′ ⊆ Y **(notice the direction of the inclusion). With this order,**
the collection of formal concepts forms the well known formal concept lattice. The Hasse diagram of this lattice for our running example is presented in Fig. 1
(left).

## 3 Representation Of A Collection Of Concepts There Are Several Desirable Properties For A Good Representation:

- **The representation must allow querying: for instance, given a collection** C
of concepts, we want to be able to select all concepts containing a given attribute or object, or all the concepts containing at least 5 objects. . .

- **The result of a query must be a collection of concepts with the same representation as the original collection (closure property). This is important to**
support successive queries on a collection.

- **In the definitions, there is a duality between objects and attributes. The**
representation should respect this duality. If it is the case, we can **use "dual"**
algorithms for dual operations. For instance, the algorithm to select all concepts containing a given attribute will be the dual of the algorithm selecting all concepts containing a given object.

The output of concept extraction algorithms (such as D-miner [1]) is **typically**
a file containing a list of concepts. This is probably the most simple way to represent a collection of concepts.

Mielik¨ainen [9] proposed to use an automaton to store an itemset collection
(an itemset is a set of attributes). Several automata are possible: for instance a simple prefix tree or a minimum automaton. However, it is necessary to define an order on the attributes to transform itemsets into strings and **choosing a** good ordering is very difficult [9] and not very natural. Using an automaton to represent concepts is also possible if we can transform concepts into strings. However, doing this without introducing a arbitrary order or losing the duality between objects and attributes seems very difficult.

To solve the problem of the need to choose an order, Mielikainen proposed to use what he called commutative automata [9]. However, these automata have a lot of edges and this is an issue if we want to query efficiently the representation. Furthermore, the commutative automata only store the attributes of concepts (and not the objects). This means that the duality is of course lost and that it will