# Feature Hashing For Large Scale Multitask Learning

Kilian Weinberger KILIAN@YAHOO-INC.COM Anirban Dasgupta ANIRBAN@YAHOO-INC.COM Josh Attenberg JOSH@CIS.POLY.EDU John Langford JL@HUNCH.NET Alex Smola ALEX@SMOLA.ORG
Yahoo! Research, 2821 Mission College Blvd., Santa Clara, CA 95051 USA
Keywords: kernels, concentration inequalities, document classification, classifier personalization, multitask learning

## Abstract

Empirical evidence suggests that hashing is an effective strategy for dimensionality reduction and practical nonparametric estimation. In this paper we provide exponential tail bounds for feature hashing and show that the interaction between random subspaces is negligible with high probability. We demonstrate the feasibility of this approach with experimental results for a new use case - multitask learning with hundreds of thousands of tasks.

## 1. Introduction

Kernel methods use inner products as the basic tool for comparisons between objects. That is, given objects x1**, . . . , x**n ∈ X for some domain X, they rely on

$$k(x_{i},x_{j}):=\langle\phi(x_{i}),\phi(x_{j})\rangle$$

to compare the features φ(xi) of xi and φ(xj ) of xj respectively.

Eq. (1) is often famously referred to as the *kernel-trick*. It allows the use of inner products between very high dimensional feature vectors φ(xi) and φ(xj ) *implicitly* through the definition of a positive semi-definite kernel matrix k without ever having to compute a vector φ(xi) directly.

This can be particularly powerful in classification settings where the original input representation has a non-linear decision boundary. Often, linear separability can be achieved in a high dimensional feature space φ(xi).

In practice, for example in text classification, researchers frequently encounter the opposite problem: the original input space is almost linearly separable (often because of the existence of handcrafted non-linear features), yet, the training set may be prohibitively large in size and very high dimensional. In such a case, there is no need to map the input vectors into a higher dimensional feature space. Instead, limited memory makes storing a kernel matrix infeasible.

For this common scenario several authors have recently proposed an alternative, but highly complimentary variation of the kernel-trick, which we refer to as the hashing-trick: one *hashes* the high dimensional input vectors x into a *lower* dimensional feature space R
m with φ : X → R
m (Langford et al., 2007; Shi et al., 2009). The parameter vector of a classifier can therefore live in R
m instead of in R
n with kernel matrices or R
din the original input space, where m ≪ n and m ≪ d. Different from random projections, the hashing-trick preserves sparsity and introduces no additional overhead to store projection matrices.

To our knowledge, we are the first to provide exponential tail bounds on the canonical distortion of these hashed inner products. We also show that the hashing-trick can be particularly powerful in multi-task learning scenarios where the original feature spaces are the cross-product of the data, X,
and the set of tasks, U. We show that one can use different hash functions for each task φ1**, . . . , φ**|U|to map the data into one joint space with little interference.

While many potential applications exist for the hashingtrick, as a particular case study we focus on collaborative email spam filtering. In this scenario, hundreds of thousands of users collectively label emails as spam or *notspam*, and each user expects a personalized classifier that reflects their particular preferences. Here, the set of tasks, U, is the number of email users (this can be very large for open systems such as Yahoo MailTMor *Gmail*TM), and the feature space spans the union of vocabularies in multitudes arXiv:0902.2206v5 [cs.AI] 27 Feb 2010