
## Of Languages.

This paper makes four main contributions: 1. In section 2 we introduce specialized hash functions with unbiased inner-products that are directly applicable to a large variety of kernel-methods. 2. In section 3 we provide exponential tail bounds that help explain why hashed feature vectors have repeatedly lead to, at times surprisingly, strong empirical results. 3. Also in section 3 we show that the interference between independently hashed subspaces is negligible with high probability, which allows large-scale multi-task learning in a very compressed space. 4. In section 5 we introduce collaborative email-spam filtering as a novel application for hash representations and provide experimental results on large-scale real-world spam data sets.

## 2. Hash Functions

We introduce a variant on the hash kernel proposed by (Shi et al., 2009). This scheme is modified through the introduction of a *signed* sum of hashed features whereas the original hash kernels use an *unsigned* sum. This modification leads to an unbiased estimate, which we demonstrate and further utilize in the following section.

Definition 1 Denote by h *a hash function* h : N →
{1**, . . . , m**}. Moreover, denote by ξ *a hash function* ξ :
N **→ {±**1}*. Then for vectors* **x, x**′ ∈ ℓ2 we define the hashed feature map φ *and the corresponding inner product* as

$$\phi_{i}^{(h,\xi)}(x)=\sum_{j:h(j)=i}\xi(i)x_{i}\tag{2}$$  _and $\left\langle x,x^{\prime}\right\rangle_{\phi}:=\left\langle\phi^{(h,\xi)}(x),\phi^{(h,\xi)}(x^{\prime})\right\rangle.$_ (3)
Although the hash functions in definition 1 are defined over the natural numbers N, in practice we often consider hash functions over arbitrary strings. These are equivalent, since each finite-length string can be represented by a unique natural number.

Usually, we abbreviate the notation φ
(h,ξ)(·) by just φ(·).

Two hash functions φ and φ′are different when φ = φ
(h,ξ)
and φ′ = φ
(h
′,ξ′)such that either h′ 6= h or ξ 6= ξ′. The purpose of the binary hash ξ is to remove the bias inherent in the hash kernel of (Shi et al., 2009).

In a multi-task setting, we obtain instances in combination with tasks, (**x, u**) ∈ X × U. We can naturally extend our definition 1 to hash pairs, and will write φu(x) = φ(**x, u**).

## 3. Analysis

The following section is dedicated to theoretical analysis of hash kernels and their applications. In this sense, the present paper continues where (Shi et al., 2009) falls short:
we prove exponential tail bounds. These bounds hold for general hash kernels, which we later apply to show how hashing enables us to do large-scale multitask learning efficiently. We start with a simple lemma about the bias and variance of the hash kernel. The proof of this lemma appears in appendix A.

  **Lemma 2**: _The hash kernel is unbiased, that is, ${\bf E}_{\phi}[\langle x,x^{\prime}\rangle_{\phi}]=\langle x,x^{\prime}\rangle$. Moreover, the variance is, $\sigma_{x,x^{\prime}}^{2}=\frac{1}{m}\left(\sum_{i\neq j}x_{i}^{2}{x^{\prime}}_{j}^{2}+x_{i}x_{i}^{\prime}x_{j}x_{j}^{\prime}\right)$, and thus, for $\|x\|_{2}=\|x^{\prime}\|_{2}=1$, $\sigma_{x,x^{\prime}}^{2}=O\left(\frac{1}{m}\right)$._
This suggests that typical values of the hash kernel should be concentrated within O( √
1 m
) of the target value. We use Chebyshev's inequality to show that half of all observations are within a range of √2σ. This, together with an indirect application of Talagrand's convex distance inequality via the result of (Liberty et al., 2008), enables us to construct exponential tail bounds.

## 3.1. Concentration Of Measure Bounds

In this subsection we show that under a hashed feature-map the length of each vector is preserved with high probability. Talagrand's inequality (Ledoux, 2001) is a key tool for the proof of the following theorem (detailed in the appendix B).

Theorem 3 Let ǫ < 1 be a fixed constant and x *be a given* instance such that kxk2 = 1*. If* m ≥ **72 log(1**/δ)/ǫ2 and kxk∞ ≤ ǫ 18√log(1/δ) log(m/δ)
, we have that

$${\rm Pr}[||x||_{\phi}^{2}-1|\geq\epsilon]\leq2\delta.\tag{4}$$

Note that an analogous result would also hold for the original hash kernel of (Shi et al., 2009), the only modification being the associated bias terms. The above result can also be utilized to show a concentration bound on the inner product between two general vectors x and x′. Corollary 4 For two vectors x and x′*, let us define*

$$\sigma:=\max(\sigma_{x,x},\sigma_{x^{\prime},x^{\prime}},\sigma_{x-x^{\prime},x-x^{\prime}})$$ $$\eta:=\max\left(\frac{\|x\|_{\infty}}{\|x\|_{2}},\frac{\|x^{\prime}\|_{\infty}}{\|x^{\prime}\|_{2}},\frac{\|x-x^{\prime}\|_{\infty}}{\|x-x^{\prime}\|_{2}}\right).$$  _Also let $\Delta=\|x\|^{2}+\|x^{\prime}\|^{2}+\|x-x^{\prime}\|^{2}$. If $m\geq\Omega(\frac{1}{\epsilon^{2}}\log(1/\delta))$ and $\eta=O(\frac{\epsilon}{\log(m/\delta)})$, then we have that_
$$\mathrm{Pr}\left[\left|\left\langle x,x^{\prime}\right\rangle_{\phi}-\left\langle x,x^{\prime}\right\rangle\right|>\epsilon\Delta/2\right]<\delta.$$

The proof for this corollary can be found in appendix C. We can also extend the bound in Theorem 3 for the maximal