The benefits of the hashing-trick leads to applications in almost all areas of machine learning and beyond. In particular, feature hashing is extremely useful whenever large numbers of parameters with redundancies need to be stored within bounded memory capacity. Personalization One powerful application of feature hashing is found in multitask learning. Theorem 7 allows us to hash multiple classifiers for different tasks into one feature space with little interaction. To illustrate, we explore this setting in the context of spam-classifier personalization.

Suppose we have thousands of users U and want to perform related but not identical classification tasks for each of the them. Users provide labeled data by marking emails as spam or *not-spam*. Ideally, for each user u ∈ U, we want to learn a predictor wu based on the data of that user solely. However, webmail users are notoriously lazy in labeling emails and even those that do not contribute to the training data expect a working spam filter. Therefore, we also need to learn an additional global predictor w0 to allow data sharing amongst all users.

Storing all predictors wi requires O(d × (|U| **+ 1))** memory. In a task like collaborative spam-filtering, |U|, the number of users can be in the hundreds of thousands and the size of the vocabulary is usually in the order of millions. The naive way of dealing with this is to eliminate all infrequent tokens. However, spammers target this memory-vulnerability by maliciously misspelling words and thereby creating highly infrequent but spam-typical tokens that "fall under the radar" of conventional classifiers. Instead, if all words are hashed into a finite-sized feature vector, infrequent but class-indicative tokens get a chance to contribute to the classification outcome. Further, large scale spam-filters (e.g. Yahoo MailTMor *GMail*TM)
typically have severe memory and time constraints, since they have to handle billions of emails per day. To guarantee a finite-size memory footprint we hash all weight vectors w0**, . . . , w**|U|into a joint, significantly smaller, feature space R
m with different hash functions φ0**, . . . , φ**|U|. The resulting hashed-weight vector wh ∈ R
m can then be written as:

$$w_{h}=\phi_{0}(w_{0})+\sum_{u\in U}\phi_{u}(w_{u}).$$

Note that in practice the weight vector wh can be learned directly in the hashed space. All un-hashed weight vectors never need to be computed. Given a new document/email x of user u ∈ U, the prediction task now consists of calculating hφ0(x) + φu(x), whi. Due to hashing we have two sources of error - distortion ǫd of the hashed inner products and the interference with other hashed weight vectors ǫi. More precisely:

$$+\,w_{u}\rangle+\epsilon_{d}+\epsilon_{i}.$$

hφ0(x) + φu(x), whi = h**x, w**0 + wui + ǫd + ǫi. (7)
The interference error consists of all collisions between φ0(x) or φu(x) with hash functions of other users,

$$\epsilon_{i}=\sum_{v\in U,v\neq0}\left\langle\phi_{0}(x),\phi_{v}(w_{v})\right\rangle+\sum_{v\in U,v\neq u}\left\langle\phi_{u}(x),\phi_{v}(w_{v})\right\rangle.$$
$${\mathfrak{h}}$$

To show that ǫiis small with high probability we can apply Theorem 7 twice, once for each term of (8). We consider each user's classification to be a separate task, and since Pv∈U,v6=0 wv is independent of the hashfunction P
φ0, the conditions of Theorem 7 apply with w =
Pv6=0 wv and we can employ it to bound the second term, v∈U,v6=0 hφu(x), φu(wv)i. The second application is identical except that all subscripts "0" are substituted with "u". For lack of space we do not derive the exact bounds. The distortion error occurs because each hash function that is utilized by user u can self-collide:

$$\epsilon_{d}=\sum_{v\in\{u,0\}}|\left\langle\phi_{v}(x),\phi_{v}(w_{v})\right\rangle-\left\langle x,w_{v}\right\rangle|.\tag{9}$$

To show that ǫd is small with high probability, we apply Corollary 4 once for each possible values of v.

In section 5 we show experimental results for this setting. The empirical results are stronger than the theoretical bounds derived in this subsection—our technique outperforms a single global classifier on hundreds thousands of users. We discuss an intuitive explanation in section 5. Massively Multiclass Estimation We can also regard massively multi-class classification as a multitask problem, and apply feature hashing in a way similar to the personalization setting. Instead of using a different hash function for each user, we use a different hash function for each class.

(Shi et al., 2009) apply feature hashing to problems with a high number of categories. They show empirically that joint hashing of the feature vector φ(**x, y**) can be efficiently achieved for problems with millions of features and thousands of classes.

$$(6)$$

Collaborative Filtering Assume that we are given a very large sparse matrix M where the entry Mij indicates what action user i took on instance j. A common example for actions and instances is user-ratings of movies (Bennett &
Lanning, ). A successful method for finding common factors amongst users and instances for predicting unobserved actions is to factorize M into M = U⊤W. If we have millions of users performing millions of actions, storing U