
## 3 Representing Csp Instances 17

The <parameters> element defines the list of formal parameters of the predicate. The syntax of this element is detailed is section 2.6.

The only authorized type is for the moment 'int' (denoting integer values). However, in the future, other types will be taken into account: "bool",
"string", etc.

The element <expression> may contain several representations of the predicate expression.

## 3.5.1 Functional Representation

It is possible to insert a functional representation of the predicate expression by inserting in <expression> an element <functional> which contains any Boolean expression defined as follows:
<integerExpression> ::=
<integer> | <identifier>
| "neg(" <integerExpression> ")"
| "abs(" <integerExpression> ")"
| "add(" <integerExpression> "," <integerExpression> ")" | "sub(" <integerExpression> "," <integerExpression> ")"
| "mul(" <integerExpression> "," <integerExpression> ")"
| "div(" <integerExpression> "," <integerExpression> ")" | "mod(" <integerExpression> "," <integerExpression> ")"
| "pow(" <integerExpression> "," <integerExpression> ")"
| "min(" <integerExpression> "," <integerExpression> ")" | "max(" <integerExpression> "," <integerExpression> ")" | "if(" <booleanExpression> "," <integerExpression> "," <integerExpression> ")"
<booleanExpression> ::=
"false" | "true" | "not(" <booleanExpression> ")"
| "and(" <booleanExpression> "," <booleanExpression> ")"
| "or(" <booleanExpression> "," <booleanExpression> ")" | "xor(" <booleanExpression> "," <booleanExpression> ")"
| "iff(" <booleanExpression> "," <booleanExpression> ")"
| "eq(" <integerExpression> "," <integerExpression> ")" | "ne(" <integerExpression> "," <integerExpression> ")"
| "ge(" <integerExpression> "," <integerExpression> ")"
| "gt(" <integerExpression> "," <integerExpression> ")" | "le(" <integerExpression> "," <integerExpression> ")" | "lt(" <integerExpression> "," <integerExpression> ")"
Hence, any constraint in intension can be defined by a predicate which corresponds to an expression built from (Boolean and integer) constants and the introduced set of functions (operators). The semantics of operators is given by Table 1.

An expression usually contains identifiers which correspond to the formal parameters of a predicate. To illustrate this, let us consider the predicate that allows defining constraints involved in any instance of the *queens* problem. It corresponds to: X 6= Y ∧ |X − Y | 6= Z. We obtain using the functional representation: