
## 3 Representing Csp Instances 18

| Operation                                     | Arity   | Syntax    | Semantics                                     | MathML     |
|-----------------------------------------------|---------|-----------|-----------------------------------------------|------------|
| Arithmetic (operands are integers) Opposite 1 | neg(x)  | -x        | <minus>                                       |            |
| Absolute Value                                | 1       | abs(x)    | | x |                                         | <abs>      |
| Addition                                      | 2       | add(x,y)  | x + y                                         | <plus>     |
| Substraction                                  | 2       | sub(x,y)  | x - y                                         | <minus>    |
| multiplication                                | 2       | mul(x,y)  | x * y                                         | <times>    |
| Integer Division                              | 2       | div(x,y)  | x div y                                       | <quotient> |
| Remainder                                     | 2       | mod(x,y)  | x mod y                                       | <rem>      |
| Power                                         | 2       | pow(x,y)  | x y                                           | <power>    |
| Minimum                                       | 2       | min(x,y)  | min(x,y)                                      | <min>      |
| Maximum                                       | 2       | max(x,y)  | max(x,y)                                      | <max>      |
| Relational (operands are integers) Equal to 2 | eq(x,y) | x = y     | <eq>                                          |            |
| Different from                                | 2       | ne(x,y)   | x 6= y                                        | <neq>      |
| Greater than or equal                         | 2       | ge(x,y)   | x ≥ y                                         | <geq>      |
| Greater than                                  | 2       | gt(x,y)   | x > y                                         | <gt>       |
| Less than or equal                            | 2       | le(x,y)   | x ≤ y                                         | <leq>      |
| Less than                                     | 2       | lt(x,y)   | x < y                                         | <lt>       |
| Logic (operands are Booleans) Logical not 1   | not(x)  | ¬ x       | <not>                                         |            |
| Logical and                                   | 2       | and(x,y)  | x ∧ y                                         | <and>      |
| Logical or                                    | 2       | or(x,y)   | x ∨ y                                         | <or>       |
| Logical xor                                   | 2       | xor(x,y)  | x ⊕ y                                         | <xor>      |
| Logical equivalence (iff)                     | 2       | iff(x,y)  | x ⇔ y                                         |            |
| Control Alternative                           | 3       | if(x,y,z) | value of y if x is true, otherwise value of z |            |

Table 1: Operators used to build predicate expressions
<predicate name="P0">
<parameters>
int X int Y int Z
</parameters>
<expression>
<functional>
and(ne(X,Y),ne(abs(sub(X,Y)),Z))
</functional>
</expression>
</predicate>

## 3.5.2 Mathml Representation

MathML is a language dedicated to represent mathematical expressions. We can represent predicate expressions using a subset of this language. It is possible to insert an XML representation of the predicate expression by inserting in
<expression> an element called <math> which contains any Boolean expression defined (in BNF notation) as follows: