version of the format will remove this limitation and allow any expression as an effective parameter.

## 3.6.3 Global Constraints

The value of the attribute reference must be the name of a global constraint, prefixed by "global:". As the character ':' cannot occur in any valid identifier, it avoids some potential collision with other identifiers. The name of global constraints is case-insensitive. Therefore, global:allDifferent and global:alldifferent represent the same constraint.

The element <constraint> may contain an element <parameters> when it represents a global constraint. If present, the element <parameters> contains a sequence of parameters specific to the global constraint. As a consequence, the description of such parameters must be given for each global constraint. It is then clear that, for each global constraint, we have to indicate its name (the one to be referenced), its parameters (and the way they are structured in XML) and its semantics. Below, we provide such information for four global constraints.

## Constraint Weightedsum (Not Defined In The Global Constraint Catalog)

Semantics Pr i=1 ki ∗ Xi op b where r denotes the arity of the constraint, ki denotes an integer, Xi the i th variable occurring in the scope of the constraint, op a relational operator in {=, 6=, >, ≥*, <,* ≤}, and b an integer.

Parameters There is a first parameter that represents a list of k dictionaries representing each product in the sum. Each dictionary contains an integer coefficient (associated with the coef key) and one variable identifier (associated with the var key). The conventional order of keys in these dictionaries is coef,var. Therefore, {/coef 2 /var X1} can be represented as {2 X1}.

There is a second parameter which is a tag denoting the relational operator.

It corresponds to an atom that must necessarily belong to {<eq/>,<ne/>,<ge/>,
<gt/>,<le/>,<lt/>} (see Table 1). There is a third parameter which is an integer.

Example V 0 + 2V 1 − 3V 2 > 12

```
<constraint name="C2" arity="3" scope="V0 V1 V2" reference="global:weightedSum">
 <parameters>
    [ { 1 V0 } { 2 V1 } { -3 V2 } ]
    <gt/>
    12
 </parameters>
</constraint>

```

The syntax of the weightedSum global constraint slightly changed from the XCSP 2.0 format to the current format. The first parameter of this constraint is now a list of dictionaries (previously, it was a list of lists). The old syntax is deprecated.